package cn.com.duiba.order.center.biz.remoteservice;

import cn.com.duiba.order.center.api.remoteservice.RemoteMainOrderFlowworkService;
import cn.com.duiba.order.center.biz.bo.AuditBo;
import cn.com.duiba.order.center.biz.bo.MainOrderFlowworkBo;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created by yansen on 16/9/29.
 */
@Service
public class RemoteMainOrderFlowworkServiceImpl implements RemoteMainOrderFlowworkService {

    @Autowired
    private AuditBo auditBo;
    @Autowired
    private MainOrderFlowworkBo mainOrderFlowworkBo;


    @Override
    public DubboResult<Void> doAuditPass(Long orderId) {
        auditBo.doAuditPass(orderId);
        return DubboResult.successResult(null);
    }

    @Override
    public DubboResult<Void> doAuditReject(Long orderId) {
        auditBo.doAuditReject(orderId);
        return DubboResult.successResult(null);
    }

    /**
     * @param orderId
     * @param expressName
     * @param expressId
     * @return
     */
    @Override
    public DubboResult<Boolean> executeObjectSend(Long orderId, String expressName, String expressId) {
        mainOrderFlowworkBo.executeObjectSend(orderId,expressName,expressId);
        return DubboResult.successResult(true);
    }

    /**
     * @param orderId
     * @param reason4consumer
     * @return
     */
    @Override
    public DubboResult<Boolean> executeObjectCancel(Long orderId, String reason4consumer) {
        mainOrderFlowworkBo.executeObjectCancel(orderId,reason4consumer);
        return DubboResult.successResult(true);
    }

    /**
     *
     * @param orderId
     * @param errorMassage
     * @return
     */
    @Override
    public DubboResult<Boolean>  adminCanceOrder(Long orderId, String errorMassage) {
        mainOrderFlowworkBo.adminCanceOrder(orderId,errorMassage);
        return DubboResult.successResult(true);
    }

        /**
         *
         * @param orderId
         * @param deliverInfo
         * @return
         */
    @Override
    public DubboResult<Boolean> executeManualLotterySend(Long orderId, String deliverInfo){
        mainOrderFlowworkBo.executeManualLotterySend(orderId,deliverInfo);
        return DubboResult.successResult(true);
    }

}
