package cn.com.duiba.order.center.biz.remoteservice;

import cn.com.duiba.order.center.api.remoteservice.RemoteOrdersTextChangeService;
import cn.com.duiba.order.center.biz.service.mainorder.orderconsumer.OrdersTextChangeService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * Created by yansen on 16/9/27.
 */
@Service
public class RemoteOrdersTextChangeServiceImpl implements RemoteOrdersTextChangeService {

    @Autowired
    private OrdersTextChangeService ordersTextChangeService;


    @Override
    public DubboResult<Integer> updateErrorMessageAndFailType(Long orderId, Long consumerId, Integer failType, String errorMessage, String error4Consumer, String error4Develper, String error4Admin) {
        return DubboResult.successResult(ordersTextChangeService.updateErrorMessageAndFailType(orderId,consumerId,failType,errorMessage,error4Consumer,error4Develper,error4Admin));
    }

    @Override
    public DubboResult<Integer> updateLastSendTime(Long orderId, Long consumerId, Date lastSendTime) {
        return DubboResult.successResult(ordersTextChangeService.updateLastSendTime(orderId,consumerId,lastSendTime));
    }

    /**
     * 更新开发者订单号
     *
     * @param orderId
     * @param consumerId
     * @param developBizId @return
     */
    @Override
    public DubboResult<Integer> updateDevelopBizId(Long orderId, Long consumerId, String developBizId) {
        return DubboResult.successResult(ordersTextChangeService.updateDevelopBizId(orderId,consumerId,developBizId));
    }

    /**
     * 更新上游订单
     *
     * @param orderId
     * @param consumerId
     * @param supplierOrderId
     */
    @Override
    public DubboResult<Integer> updateSupplierOrderId(Long orderId, Long consumerId, Long supplierOrderId) {
        return DubboResult.successResult(ordersTextChangeService.updateSupplierOrderId(orderId,consumerId,supplierOrderId));
    }

    /**
     * 释放一张优惠券
     *
     * @param orderId
     * @param consumerId
     */
    @Override
    public DubboResult<Integer> releaseCouponByOrderId(Long orderId, Long consumerId){
        return DubboResult.successResult(ordersTextChangeService.releaseCouponByOrderId(orderId,consumerId));
    }

    /**
     * 下订单,更新优惠券ID
     */
    @Override
    public DubboResult<Integer> updateCouponId(Long orderId,Long consumerId,Long couponId){
        return DubboResult.successResult(ordersTextChangeService.updateCouponId(orderId,consumerId,couponId));
    }
}
