package cn.com.duiba.order.center.biz.service.credits;

import cn.com.duiba.order.center.api.dto.SupplierProductDto;
import cn.com.duiba.order.center.biz.dao.credits.SupplierProductsDao;
import cn.com.duiba.order.center.biz.entity.SupplierProductEntity;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by yansen on 16/9/27.
 */
@Service
public class SupplierProductsService {
    @Autowired
    private SupplierProductsDao supplierProductsDao;

    /**
     *
     * @param supplier
     * @return
     */
    public SupplierProductDto findBySupplier(String supplier){
        return BeanUtils.copy(supplierProductsDao.findBySupplier(supplier),SupplierProductDto.class);
    }

    /**
     *
     * @param supplierProductDto
     * @return
     */
    public SupplierProductDto insert(SupplierProductDto supplierProductDto){
        SupplierProductEntity entity=BeanUtils.copy(supplierProductDto,SupplierProductEntity.class);
        supplierProductsDao.insert(entity);
        supplierProductDto.setId(entity.getId());
        return supplierProductDto;
    }

    /**
     *
     * @param id
     * @return
     */
    public SupplierProductDto findById(Long id){
        return BeanUtils.copy(supplierProductsDao.findById(id),SupplierProductDto.class);
    }

    /**
     *
     * @param supplier
     * @param facePrice
     * @return
     */
    public List<SupplierProductDto> findBySupplierAndFacePrice( String supplier, Integer facePrice){
        return BeanUtils.copyList(supplierProductsDao.findBySupplierAndFacePrice(supplier,facePrice),SupplierProductDto.class);
    }

    /**
     *
     * @param supplier
     * @param productId
     * @return
     */
    public List<SupplierProductDto> findBySupplierAndMobile(String supplier,String productId){
        return BeanUtils.copyList(supplierProductsDao.findBySupplierAndMobile(supplier,productId),SupplierProductDto.class);
    }

}
