package cn.com.duiba.order.center.biz.service.mainorder;


import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONObject;

import cn.com.duiba.boot.ext.autoconfigure.logger.JsonLoggerFactory;
import cn.com.duiba.order.center.api.dto.OrderSyncMessageDto;
import cn.com.duiba.order.center.api.dto.OrdersDto;
import cn.com.duiba.order.center.api.dto.TuiAOrderSyncMessage;
import cn.com.duiba.order.center.biz.constant.TopicConstant;
import cn.com.duiba.order.center.biz.service.message.MessageService;

/**
 * 订单同步服务
 */
@Service
public class OrderSyncService  {

	private static Logger log = JsonLoggerFactory.getLogger(OrderSyncService.class);

	@Autowired
	private MessageService messageService;
	@Autowired
	private TopicConstant topicConstant;

	/**
	 *
	 * @param orderId
	 * @param consumerId
     */
	public void sync(Long orderId, Long consumerId) {
		try {
			//发送消息到MQ
			OrderSyncMessageDto msg = new OrderSyncMessageDto();
			msg.setOrderId(orderId);
			msg.setConsumerId(consumerId);
			String body = JSONObject.toJSONString(msg);
			messageService.sendMsg(topicConstant.getTopicOrdersDataSync(), body);
		} catch (Exception e) {
			log.error("order sync error:[orderId:" + orderId + " consumerId:" + consumerId + "]", e);
		}
	}
	
	public void sendMsgToTuia(OrdersDto order) {
		try {
			TuiAOrderSyncMessage msg = new TuiAOrderSyncMessage();
			msg.setOrderId(order.getId());
			msg.setConsumerId(order.getConsumerId());
			msg.setAppId(order.getAppId());
			msg.setItemId(order.getItemId());
			msg.setOperatingActivityId(order.getRelationId());
			msg.setGmtCreate(order.getGmtCreate());
			String body = JSONObject.toJSONString(msg);
			messageService.sendMsg(topicConstant.getCouponToTuia(), body);
		} catch (Exception e) {
			log.error("tuia sync error:[orderId:" + order.getId() + " consumerId:" + order.getConsumerId() + "]", e);
		}
	}

}
