package cn.com.duiba.order.center.biz.tool;

import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import cn.com.duiba.boot.ext.autoconfigure.logger.JsonLoggerFactory;

/**
 * kafka客户端
 */
@Component
public class KafkaClient implements InitializingBean{
	
	private static Logger log = JsonLoggerFactory.getLogger(KafkaClient.class);

    private Producer<String,String> producer = null;

    @Value("${trade.kafka.bootstrap.servers}")
    private String bootstrapServers;

    public String getBootstrapServers() {
		return bootstrapServers;
	}

	public Producer<String,String> getProducer() {
        return producer;
    }

	/**
	 * 异步发送消息
	 */
	public String sendMsg(String queueName, String body) {
		String id = UUID.randomUUID().toString().replaceAll("-", "");
		producer.send(new ProducerRecord<String, String>(queueName, id, body), new Callback() {
			@Override
			public void onCompletion(RecordMetadata recordMetadata, Exception e) {
				if (e != null) {
					log.error("producer.send", e);
				}
			}
		});
		return id;
	}

	/**
	 * 同步发送消息
	 * @throws ExecutionException 
	 * @throws InterruptedException 
	 */
	public String sendMsgSync(String queueName, String body) {
		String id = UUID.randomUUID().toString().replaceAll("-", "");
		Future<RecordMetadata> future = producer.send(new ProducerRecord<String, String>(queueName, id, body), new Callback() {
			@Override
			public void onCompletion(RecordMetadata recordMetadata, Exception e) {
				if (e != null) {
					log.error("producer.send", e);
				}
			}
		});
		try {
			future.get();
		} catch (Exception e) {
			log.error("onCompletion is exception",e);
			throw new TradeCenterException("sendMsgSync error");
		}
		return id;
	}

	@Override
	public void afterPropertiesSet() throws Exception {
		Properties props = new Properties();
		props.put("bootstrap.servers", bootstrapServers);
		props.put("acks", "all");
		props.put("retries", 3);
		props.put("batch.size", 16384);
		props.put("linger.ms", 0);
		props.put("request.timeout.ms", 30000);
		props.put("metadata.fetch.timeout.ms", 10000);
		props.put("buffer.memory", 33554432);
		props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
		props.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
		producer = new KafkaProducer<>(props);
	}
}
