package cn.com.duiba.order.center.biz.bo;

import java.util.Date;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

import com.google.common.base.Objects;

import cn.com.duiba.order.center.api.dto.OrdersDto;
import cn.com.duiba.order.center.api.dto.SupplierOrderDto;
import cn.com.duiba.order.center.biz.entity.SupplierOrderEntity;
import cn.com.duiba.order.center.biz.service.credits.AmbOrderFastService;
import cn.com.duiba.order.center.biz.service.credits.AmbSubOrdersService;
import cn.com.duiba.order.center.biz.service.credits.SupplierOrdersService;
import cn.com.duiba.order.center.biz.service.mainorder.OrderSyncService;
import cn.com.duiba.order.center.biz.service.mainorder.orderconsumer.OrderSimpleService;
import cn.com.duiba.order.center.biz.service.mainorder.orderconsumer.OrdersStatusChangeService;
import cn.com.duiba.service.domain.dataobject.OrdersDO;
import cn.com.duiba.service.exception.BusinessException;

/**
 * Created by yansen on 16/10/9.
 */
@Service
public class TransactionBo {

    @Autowired
    private OrdersStatusChangeService ordersStatusChangeService;
    @Autowired
    private OrderSimpleService ordersSimpleService;
    @Resource
    private PlatformTransactionManager ordersConsumerTransactionManager;
    @Autowired
    private SupplierOrdersService supplierOrdersService;
    @Autowired
    private OrderSyncService orderSyncService;
    @Autowired
    private AmbSubOrdersService ambSubOrdersService;
    @Autowired
    private AmbOrderFastService ambOrderFastService;

    public static final String ERROR_STRING_INVALID_STATUS="状态不正确，无法执行";

    /**
     *
     * @param orders
     * @throws BusinessException
     */
    public void createPayBackRecordAtMakeFail(OrdersDto orders)throws BusinessException{
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        TransactionStatus status = ordersConsumerTransactionManager.getTransaction(def);
        try
        {
            /*** 修改字定单结算状态为 none ***/
            ambSubOrdersService.updateSettleStatusNoneBySubId(orders.getSubOrderId(), orders.getConsumerPayPrice());
            /** 加钱购 定单失败 ，删除加速表中数据 **/
            ambOrderFastService.deleteByOrderId(orders.getId());
        } catch (Exception e)
        {
            status.setRollbackOnly();
            throw e;
        } finally
        {
            ordersConsumerTransactionManager.commit(status);
        }
    }

    /**
     *
     * @param orderId
     * @param consumerId
     * @return
     * @throws BusinessException
     */
    public boolean doMakeConsumeSuccess(Long orderId, Long consumerId) throws BusinessException {
        TransactionDefinition def = new DefaultTransactionDefinition();
        TransactionStatus status = ordersConsumerTransactionManager.getTransaction(def);
        try {
            OrdersDto order = ordersSimpleService.select4updatelock(orderId, consumerId);
            if (!OrdersDto.StatusCreate.equals(order.getStatus())) {
                status.setRollbackOnly();
                throw new BusinessException(ERROR_STRING_INVALID_STATUS);
            }
            int ret = ordersStatusChangeService.doMakeConsumeSuccess(order.getId(), consumerId);
            if (ret == 0) {
                status.setRollbackOnly();
                throw new BusinessException(ERROR_STRING_INVALID_STATUS);
            }
        } catch (BusinessException e) {
            status.setRollbackOnly();
            throw e;
        } finally {
            ordersConsumerTransactionManager.commit(status);
            orderSyncService.sync(orderId, consumerId);
        }

        return true;
    }

    /**
     *
     * @param orderId
     * @param consumerId
     * @param failType
     * @param error4consumer
     * @param error4developer
     * @param error4admin
     * @return
     * @throws BusinessException
     */
    public boolean doMakeConsumeFail(Long orderId, Long consumerId, Integer failType, String error4consumer, String error4developer, String error4admin) throws BusinessException {
        TransactionDefinition def = new DefaultTransactionDefinition();
        TransactionStatus status = ordersConsumerTransactionManager.getTransaction(def);
        try {
            OrdersDto order = ordersSimpleService.select4updatelock(orderId, consumerId);
            if (!OrdersDto.StatusCreate.equals(order.getStatus())) {
                status.setRollbackOnly();
                throw new BusinessException(ERROR_STRING_INVALID_STATUS);
            }
            String subError4consumer = StringUtils.substring(error4consumer, 0, 200);
            String subError4developer = StringUtils.substring(error4developer, 0, 200);
            String subError4admin = StringUtils.substring(error4admin, 0, 200);
            int ret = ordersStatusChangeService.doMakeConsumeFail(order.getId(), consumerId, failType, subError4consumer, subError4developer, subError4admin);
            if (ret == 0) {
                status.setRollbackOnly();
                throw new BusinessException(ERROR_STRING_INVALID_STATUS);
            }
        } catch (BusinessException e) {
            status.setRollbackOnly();
            throw e;
        } finally {
            ordersConsumerTransactionManager.commit(status);
            orderSyncService.sync(orderId, consumerId);

        }

        return true;
    }

    /**
     *
     * @param orderId
     * @param consumerId
     * @return
     * @throws BusinessException
     */
    public boolean doAmbPaySuccess(Long orderId, Long consumerId) throws BusinessException {
        TransactionDefinition def = new DefaultTransactionDefinition();
        TransactionStatus status = ordersConsumerTransactionManager.getTransaction(def);
        try {
            OrdersDto order = ordersSimpleService.select4updatelock(orderId, consumerId);
            if (OrdersDto.StatusConsumeSuccess.equals(order.getStatus()) && OrdersDto.ConsumerPayStatusWaitPay.equals(order.getConsumerPayStatus())) {
                int ret = ordersStatusChangeService.doAmbConsumerPayStatusPaySuccess(orderId, consumerId);
                if (ret == 0) {
                    throw new BusinessException(ERROR_STRING_INVALID_STATUS);
                }
            } else {
                throw new BusinessException("状态不正确，无法进行审核操作");
            }
        } catch (BusinessException e1) {
            status.setRollbackOnly();
            throw e1;
        } finally {
            ordersConsumerTransactionManager.commit(status);
            orderSyncService.sync(orderId, consumerId);
        }
        return true;
    }

    /**
     *
     * @param orderId
     * @param consumerId
     * @return
     * @throws BusinessException
     */
    public boolean doAuditReject(Long orderId, Long consumerId) throws BusinessException {
        TransactionDefinition def = new DefaultTransactionDefinition();
        TransactionStatus status = ordersConsumerTransactionManager.getTransaction(def);
        try {
            OrdersDto order = ordersSimpleService.select4updatelock(orderId, consumerId);
            if (order.getConsumerPayPrice() > 0 && !OrdersDto.ConsumerPayStatusPaySuccess.equals(order.getConsumerPayStatus())) {
                throw new BusinessException("加钱购付费状态异常");

            }
            if (OrdersDto.AuditStatusWait.equals(order.getAuditStatus()) && OrdersDto.StatusConsumeSuccess.equals(order.getStatus())) {
                order.setAuditStatus(OrdersDto.AuditStatusReject);
                order.setAuditTime(new Date());
                String errorInfo="审核不通过";
                order.setError4Consumer(errorInfo);
                order.setError4Developer(errorInfo);
                order.setError4Admin(errorInfo);
                order.setFailType(OrdersDto.FailTypeAuditReject);

                int ret = ordersStatusChangeService.doAuditReject(order.getId(), order.getConsumerId(), order.getError4Consumer(), order.getError4Developer(), order.getError4Admin(), order.getFailType());
                if (ret == 0) {
                    status.setRollbackOnly();
                    throw new BusinessException(ERROR_STRING_INVALID_STATUS);
                }
            } else {
                status.setRollbackOnly();
                throw new BusinessException("状态不正确，无法进行审核操作");
            }
        } catch (BusinessException e1) {
            status.setRollbackOnly();
            throw e1;
        } finally {
            ordersConsumerTransactionManager.commit(status);
            orderSyncService.sync(orderId, consumerId);
        }
        return true;
    }

    /**
     *
     * @param orderId
     * @param consumerId
     * @return
     * @throws BusinessException
     */
    public boolean doMakeSuccess(Long orderId, Long consumerId) throws BusinessException {
        TransactionDefinition def = new DefaultTransactionDefinition();
        TransactionStatus status = ordersConsumerTransactionManager.getTransaction(def);
        if (!status.isNewTransaction()) {
            throw new BusinessException("doMakeSuccess 不能嵌套事务");
        }
        try {
            OrdersDto order = ordersSimpleService.select4updatelock(orderId, consumerId);
            if (!OrdersDto.StatusSuccess.equals(order.getStatus()) && !OrdersDto.StatusFAil.equals(order.getStatus())) {

                if (order.getSupplierOrderId() != null) {
                    SupplierOrderDto so4u = new SupplierOrderDto(order.getSupplierOrderId());
                    so4u.setStatus(SupplierOrderEntity.StatusSuccess);
                    supplierOrdersService.update(so4u);
                }
                String duibaPayStatus = null;
                /***duibaPayStatus  为空的时候  动态SQL不进行更新操作。***/
                if (!Objects.equal(OrdersDto.DuibaPayStatusNone, order.getDuibaPayStatus())) {
                    duibaPayStatus = OrdersDto.DuibaPayStatusSuccess;
                }
                String payStatus = null;
                /***payStatus  为空的时候  动态SQL不进行更新操作。***/
                if (!Objects.equal(OrdersDto.PayStatusNone, order.getPayStatus())) {
                    payStatus = OrdersDto.PayStatusSuccess;
                }
                /**加钱购定单成功流程 **/
                String consumerPayStatus = null;
                if (order.getConsumerPayPrice() > 0) {
                    if (OrdersDto.ConsumerPayStatusPaySuccess.equals(order.getConsumerPayStatus())) {
                        consumerPayStatus = OrdersDto.ConsumerPayStatusSuccess;
                    }
                }
                int ret = ordersStatusChangeService.doMakeSuccess(orderId, consumerId, payStatus, duibaPayStatus, consumerPayStatus);
                if (ret == 0) {
                    status.setRollbackOnly();
                    throw new BusinessException(ERROR_STRING_INVALID_STATUS);
                }
                if (isSendToTuia(order)) {
        			orderSyncService.sendMsgToTuia(order);
        		}
            } else {
                status.setRollbackOnly();
                throw new BusinessException("状态不正确，无法进行成功操作");
            }
        } catch (BusinessException e1) {
            status.setRollbackOnly();
            throw e1;
        } finally {
            ordersConsumerTransactionManager.commit(status);
            orderSyncService.sync(orderId, consumerId);
        }

        return true;
    }
    
    /**
     * 是否发送消息给推啊消息
     * @param order
     * @return
     */
    private boolean isSendToTuia(OrdersDto order) {
		if (order == null) {
			return false;
		}
		if (!OrdersDto.type_coupon.equals(order.getType())) {
			return false;// 必须是优惠券
		}
		return true;
	}

    /**
     *
     * @param orderId
     * @param consumerId
     * @return
     * @throws BusinessException
     */
    public boolean doMakeFail(Long orderId, Long consumerId) throws BusinessException {
        OrdersDto tempOrder = ordersSimpleService.findById(orderId, consumerId);
        if (tempOrder.getActualPrice() > 0 || tempOrder.getDuibaActualPrice() > 0) {
            DefaultTransactionDefinition def = new DefaultTransactionDefinition();
            TransactionStatus status = ordersConsumerTransactionManager.getTransaction(def);
            if (!status.isNewTransaction()) {
                throw new BusinessException("doMakeFail 不能嵌套事务");
            }
            try {
                OrdersDto order = ordersSimpleService.select4updatelock(orderId, consumerId);
                if (OrdersDto.StatusSuccess.equals(order.getStatus()) || OrdersDto.StatusFAil.equals(order.getStatus())) {
                    throw new BusinessException(ERROR_STRING_INVALID_STATUS);
                }
                if (OrdersDto.PayStatusSuccess.equals(order.getPayStatus()) || OrdersDto.PayStatusPayback.equals(order.getPayStatus())) {
                    throw new BusinessException(ERROR_STRING_INVALID_STATUS);
                }
                if (OrdersDto.DuibaPayStatusPayback.equals(order.getDuibaPayStatus()) || OrdersDto.DuibaPayStatusSuccess.equals(order.getDuibaPayStatus())) {
                    throw new BusinessException(ERROR_STRING_INVALID_STATUS);
                }

                /****duibaPayStatus  为空的时候  动态SQL不进行更新操作***/
                String duibaPayStatus = null;
                if (!Objects.equal(OrdersDto.DuibaPayStatusNone, order.getDuibaPayStatus())) {
                    duibaPayStatus = order.getDuibaPayStatus();
                }
                String payStatus = null;
                /****payStatus  为空的时候  动态SQL不进行更新操作***/
                if (!Objects.equal(OrdersDto.PayStatusNone, order.getPayStatus())) {
                    payStatus = order.getPayStatus();
                }


                /**加钱购主定单失败  处理流程**/
                String consumerPayStatus = null;
                Long consumerPaybackPrice = null;
                if (order.getConsumerPayPrice() > 0) {
                    if (OrdersDto.ConsumerPayStatusWaitPay.equals(order.getConsumerPayStatus())) {
                        consumerPayStatus = OrdersDto.ConsumerPayStatusCanceled;
                    } else if (OrdersDto.ConsumerPayStatusPaySuccess.equals(order.getConsumerPayStatus())) {
                        /*** 如果是付款成功 状态   全额退款***/
                        consumerPayStatus = OrdersDto.ConsumerPayStatusPayBack;
                        consumerPaybackPrice = order.getConsumerPayPrice();
                    }
                }
                int ret = ordersStatusChangeService.doMakeFail(orderId, consumerId, payStatus, duibaPayStatus, consumerPayStatus, consumerPaybackPrice);
                if (ret == 0) {
                    status.setRollbackOnly();
                    throw new BusinessException(ERROR_STRING_INVALID_STATUS);
                }


            } catch (BusinessException e) {
                status.setRollbackOnly();
                throw e;
            } finally {
                ordersConsumerTransactionManager.commit(status);
                orderSyncService.sync(orderId, consumerId);
            }
            return true;
        } else {
            TransactionDefinition def = new DefaultTransactionDefinition();
            TransactionStatus status = ordersConsumerTransactionManager.getTransaction(def);
            try {
                OrdersDto order = ordersSimpleService.select4updatelock(orderId, consumerId);
                if (!OrdersDto.StatusSuccess.equals(order.getStatus()) && !OrdersDto.StatusFAil.equals(order.getStatus())) {
                    /**加钱购主定单失败  处理流程**/
                    String consumerPayStatus = null;
                    Long consumerPaybackPrice = null;
                    if (order.getConsumerPayPrice() > 0) {
                        if (OrdersDto.ConsumerPayStatusWaitPay.equals(order.getConsumerPayStatus())) {
                            consumerPayStatus = OrdersDto.ConsumerPayStatusCanceled;
                        } else if (OrdersDto.ConsumerPayStatusPaySuccess.equals(order.getConsumerPayStatus())) {
                            /*** 如果是付款成功 状态   全额退款***/
                            consumerPayStatus = OrdersDto.ConsumerPayStatusPayBack;
                            consumerPaybackPrice = order.getConsumerPayPrice();
                        }
                    }
                    int ret = ordersStatusChangeService.doMakeFail(orderId, consumerId, null, null, consumerPayStatus, consumerPaybackPrice);

                    if (ret == 0) {
                        status.setRollbackOnly();
                        throw new BusinessException(ERROR_STRING_INVALID_STATUS);
                    }
                } else {
                    status.setRollbackOnly();
                    throw new BusinessException("状态不正确，无法执行失败操作");
                }
            } catch (BusinessException e) {
                status.setRollbackOnly();
                throw e;
            } finally {
                ordersConsumerTransactionManager.commit(status);
                orderSyncService.sync(orderId, consumerId);
            }

            return true;
        }
    }

    /**
     *
     * @param orderId
     * @param consumerId
     * @param supplierOrder
     * @param bizParams
     * @param brief
     * @return
     * @throws BusinessException
     */
    public boolean doUpdateAllowInputUsed(Long orderId, Long consumerId,
                                          SupplierOrderDto supplierOrder, String bizParams, String brief) throws BusinessException {
        TransactionDefinition def = new DefaultTransactionDefinition();
        TransactionStatus status = ordersConsumerTransactionManager.getTransaction(def);
        try {
            OrdersDto order = ordersSimpleService.select4updatelock(orderId, consumerId);
            if (OrdersDto.StatusSuccess.equals(order.getStatus()) || OrdersDto.StatusFAil.equals(order.getStatus()) ||
                    !order.getAllowInputAgain()) {
                throw new BusinessException(ERROR_STRING_INVALID_STATUS);
            }
            supplierOrdersService.insert(supplierOrder);
            int ret = ordersStatusChangeService.doUpdateAllowInputUsed(order.getId(), consumerId, supplierOrder.getId(), bizParams, brief);
            if (ret == 0) {
                throw new BusinessException(ERROR_STRING_INVALID_STATUS);
            }
        } catch (BusinessException e1) {
            status.setRollbackOnly();
            throw e1;
        } finally {
            ordersConsumerTransactionManager.commit(status);
            orderSyncService.sync(orderId, consumerId);
        }

        return true;
    }

    /**
     * 实物重填机会，只允许执行一次
     * @param orderId
     * @param supplierOrder
     * @param bizParams
     * @param brief
     * @return
     * @throws BusinessException
     */
    public boolean doUpdateAllowInputUsed4Object(Long orderId, Long consumerId,
                                                 SupplierOrderDto supplierOrder, String bizParams) throws BusinessException {
        TransactionDefinition def = new DefaultTransactionDefinition();
        TransactionStatus status = ordersConsumerTransactionManager.getTransaction(def);
        try {
            OrdersDto order=ordersSimpleService.select4updatelock(orderId, consumerId);
            if(OrdersDO.StatusSuccess.equals(order.getStatus()) || OrdersDO.StatusFAil.equals(order.getStatus())||
                    !order.getAllowInputAgain()){
                throw new BusinessException("状态不正确，无法执行");
            }
            supplierOrdersService.insert(supplierOrder);
            int ret=ordersStatusChangeService.doUpdateAllowInputUsed4Object(order.getId(),consumerId, supplierOrder.getId(), bizParams);
            if(ret==0){
                throw new BusinessException("状态不正确，无法执行");
            }
        } catch (BusinessException e1) {
            status.setRollbackOnly();
            throw e1;
        } finally{
            ordersConsumerTransactionManager.commit(status);
            orderSyncService.sync(orderId, consumerId);
        }

        return true;
    }

    public boolean doAmbStatusAfterSend(Long orderId, Long consumerId) throws BusinessException {
        TransactionDefinition def = new DefaultTransactionDefinition();
        TransactionStatus status = ordersConsumerTransactionManager.getTransaction(def);
        try {
            OrdersDto order=ordersSimpleService.select4updatelock(orderId, consumerId);
            if(OrdersDO.StatusConsumeSuccess.equals(order.getStatus())&&OrdersDO.ConsumerPayStatusPaySuccess.equals(order.getConsumerPayStatus())){
                int ret=ordersStatusChangeService.doAmbStatusAfterSend(orderId, consumerId);
                if(ret==0){
                    throw new BusinessException("状态不正确，无法执行");
                }
            }else{
                throw new BusinessException("状态不正确，无法进行审核操作");
            }
        } catch (Exception e1) {
            status.setRollbackOnly();
            throw e1;
        } finally{
            ordersConsumerTransactionManager.commit(status);
            orderSyncService.sync(orderId, consumerId);
        }
        return true;
    }
}
