package cn.com.duiba.order.center.biz.dao;

/**
 * Created by yansen on 16/9/21.
 */
public class BaseOrderTool {

    private BaseOrderTool(){
        throw new IllegalAccessError();
    }

    /**
     *
     * @param consumerId
     * @return
     */
    public static String getTableNameStr(long consumerId) {
        return"orders_" + getTableSuffix(consumerId);
    }

    /**
     *
     * @param suffix
     * @return
     */
    public static String getTableNameBySuffix(String suffix) {
        return "orders_" + suffix;
    }

    /**
     *
     * @param consumerId
     * @return
     */
    public static String getTableSuffix(long consumerId) {
        long tbInt = consumerId % 1024;
        String tb = Long.toString(tbInt);
        if (tbInt < 10) {
            tb = "000" + tbInt;
        } else if (tbInt < 100) {
            tb = "00" + tbInt;
        } else if (tbInt < 1000) {
            tb = "0" + tbInt;
        }
        return tb;
    }

    /**
     *
     * @param orderId
     * @return
     */
    public static String getTableSuffixByOrderId(Long orderId){
        if(orderId<=10000000000l){//改造前订单号小于10000000000
            return "";
        }
        String orderIdStr=orderId.toString();
        Integer tbInt=Integer.valueOf(orderIdStr.substring(orderIdStr.length()-4));
        String tb = tbInt + "";
        if (tbInt < 10) {
            tb = "000" + tbInt;
        } else if (tbInt < 100) {
            tb = "00" + tbInt;
        } else if (tbInt < 1000) {
            tb = "0" + tbInt;
        }
        return tb;
    }

    /**
     *
     * @param str
     * @param maxLen
     * @return
     */
    public static String subString(String str, int maxLen) {
        if (str == null) {
            return null;
        }
        if (str.length() > maxLen) {
            return str.substring(0, maxLen);
        }
        return str;
    }
}
