package cn.com.duiba.order.center.biz.dao.consumerrecord;

import cn.com.duiba.order.center.biz.entity.ConsumerExchangeRecordEntity;
import cn.com.duiba.order.center.biz.entity.ConsumerExchangeRecordSequenceEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * Created by yansen on 16/9/30.
 */
public interface ConsumerExchangeRecordDao {

    /**
	 *
	 * @param consumerExchangeRecordEntity
     */
	void insert(ConsumerExchangeRecordEntity consumerExchangeRecordEntity);

	/**
	 *
	 * @param consumerExchangeRecordSequenceEntity
	 * @return
     */
    long getSequenceID(ConsumerExchangeRecordSequenceEntity consumerExchangeRecordSequenceEntity);

    /**
	 *
	 * @param map
	 * @return
     */
    ConsumerExchangeRecordEntity selectOneByMapCondition(Map<String, Object> map);

	/**
	 *
	 * @param map
	 * @return
     */
	List<ConsumerExchangeRecordEntity> selectListByMapCondition(Map<String, Object> map);

	/**
	 *
	 * @param map
	 * @return
     */
	List<ConsumerExchangeRecordEntity> selectPageListByMapCondition(Map<String, Object> map);
	
	/**
	 * 分页查询不包含福袋没有过期的兑换记录
	 * @param consumerId
	 * @param start
	 * @param pageSize
	 * @param tableName
	 * @return
	 */
	List<ConsumerExchangeRecordEntity> selectValidWithoutFD(
			@Param("consumerId") Long consumerId,
			@Param("start") Integer start,
			@Param("pageSize") Integer pageSize,
			@Param("tableName") String tableName
			);
	
	/**
	 * 分页查询不包含福袋已过期的兑换记录（90天内）
	 * @param consumerId
	 * @param start
	 * @param pageSize
	 * @param tableName
	 * @return
	 */
	List<ConsumerExchangeRecordEntity> selectInvalidWithoutFD(
			@Param("consumerId") Long consumerId,
			@Param("start") Integer start,
			@Param("pageSize") Integer pageSize,
			@Param("tableName") String tableName
			);

	/**
	 *
	 * @param consumerExchangeRecordSequenceEntity
	 * @return
     */
	int update(ConsumerExchangeRecordEntity consumerExchangeRecordSequenceEntity);

	int tempDeleteRecord(@Param("id")Long id,@Param("tableName") String tableName);

	List<ConsumerExchangeRecordEntity> getByOrderId(@Param("orderId")Long iorderIdd,@Param("tableName") String tableName);
}
