package cn.com.duiba.order.center.biz.dao.orderconsumer;


import org.apache.ibatis.annotations.Param;

/**
 * 主订单流程节点变更操作类
 * <p>
 * 此类只能提供给 XXWorker 调用
 * 其他类不得引用此类，进行调用！！！
 *
 * @author xuhengfei
 */
public interface FlowworkStatusChangeDao {


    /**
     * 扣费节点新增方法
     * @param orderId
     * @param consumerId
     * @param tableName
     * @return
     */
    public int changeCreate2DeveloperPay(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    /**
     *
     * @param orderId
     * @param consumerId
     * @param tableName
     * @return
     */
    public int changeDeveloperPay2DuibaPay(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    /**
     *
     * @param orderId
     * @param consumerId
     * @param tableName
     * @return
     */
    public int changeDuibaPay2ConsumeCredits(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    /**
     *
     * @param orderId
     * @param consumerId
     * @param tableName
     * @return
     */
    public int changeConsumeCredits2ConsumerPay(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    /**
     *
     * @param orderId
     * @param consumerId
     * @param tableName
     * @return
     */
    public int changeConsumerPay2Audit(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    /**
     *
     * @param orderId
     * @param consumerId
     * @param tableName
     * @return
     */
    public int changeAudit2SupplierExchange(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    /**
     *
     * @param orderId
     * @param consumerId
     * @param tableName
     * @return
     */
    public int changeSupplierExchange2AfterSend(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    /**
     *
     * @param orderId
     * @param consumerId
     * @param tableName
     * @return
     */
    public int changeAfterSend2Success(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    /**
     *
     * @param orderId
     * @param consumerId
     * @param tableName
     * @return
     */
    public int changeCreate2Fail(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    /**
     *
     * @param orderId
     * @param consumerId
     * @param tableName
     * @return
     */
    public int changeConsumeCredits2Fail(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    /**
     *
     * @param orderId
     * @param consumerId
     * @param tableName
     * @return
     */
    public int changeConsumerPay2Fail(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    /**
     *
     * @param orderId
     * @param consumerId
     * @param error4consumer
     * @param tableName
     * @return
     */
    public int changeCreate2Fail2(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("error4consumer") String error4consumer, @Param("tableName") String tableName);

    /**
     *
     * @param orderId
     * @param consumerId
     * @param tableName
     * @return
     */
    public int changeAfterSend2Fail(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    /**
     *
     * @param orderId
     * @param consumerId
     * @param tableName
     * @return
     */
    public int changeDuibaPay2Fail(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    /**
     *
     * @param orderId
     * @param consumerId
     * @param tableName
     * @return
     */
    public int changeDeveloperPay2Fail(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    /**
     *
     * @param orderId
     * @param consumerId
     * @param tableName
     * @return
     */
    public int changeAudit2Fail(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    /**
     *
     * @param orderId
     * @param consumerId
     * @param tableName
     * @return
     */
    public int changeSupplierExchange2Fail(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    /**
     * 强制从 strated -> complete
     * @param orderId
     * @param consumerId
     * @param tableName
     * @return
     */
    public int markCreateComplete(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    /**
     * 从started -> complete
     * @param orderId
     * @param consumerId
     * @param tableName
     * @return
     */
    public int markDeveloperPayComplete(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    /**
     *
     * @param orderId
     * @param consumerId
     * @param tableName
     * @return
     */
    public int markDuibaPayComplete(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    /**
     * 强制从 strated -> complete
     * @param orderId
     * @param consumerId
     * @param tableName
     * @return
     */
    public int markConsumeCreditsComplete(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    /**
     * 强制从 strated -> complete
     * @param orderId
     * @param consumerId
     * @param tableName
     * @return
     */
    public int markConsumerPayComplete(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    /**
     * 强制从 strated -> complete
     * @param orderId
     * @param consumerId
     * @param tableName
     * @return
     */
    public int markAuditComplete(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    /**
     * 强制从 strated -> complete
     * @param orderId
     * @param consumerId
     * @param tableName
     * @return
     */
    public int markSupplierExchangeComplete(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    /**
     * 强制从 strated -> complete
     * @param orderId
     * @param consumerId
     * @param tableName
     * @return
     */
    public int markAfterSendComplete(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    /**
     * 强制从 strated -> complete
     * @param orderId
     * @param consumerId
     * @param tableName
     * @return
     */
    public int markSuccessComplete(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    /**
     * 强制从 strated -> complete
     * @param orderId
     * @param consumerId
     * @param tableName
     * @return
     */
    public int markFailComplete(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    /**
     * 兼容处理老订单
     * 由于老订单的flowwork_stage = null
     * 这里需要将正确的flowwork_stage设置进去
     * @param orderId
     * @param consumerId
     * @param flowStage
     * @param tableName
     * @return
     */
    public int compatibleOldOrderStatus(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("flowStage")String flowStage, @Param("tableName") String tableName);

    /**
     *
     * @param orderId
     * @param consumerId
     * @param tableName
     * @return
     */
    public int changeCreate2FailStarted(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    /**
     *
     * @param orderId
     * @param consumerId
     * @param tableName
     * @return
     */
    public int changeAfterSend2FailStarted(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    /**
     *
     * @param orderId
     * @param consumerId
     * @param tableName
     * @return
     */
    public int changeConsumeCredits2FailStarted(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    /**
     *
     * @param orderId
     * @param consumerId
     * @param tableName
     * @return
     */
    public int changeConsumerPay2FailStarted(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    /**
     *
     * @param orderId
     * @param consumerId
     * @param tableName
     * @return
     */
    public int changeAudit2FailStarted(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    /**
     *
     * @param orderId
     * @param consumerId
     * @param tableName
     * @return
     */
    public int changeSupplierExchange2FailStarted(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    /**
     *
     * @param orderId
     * @param consumerId
     * @param tableName
     * @return
     */
    public int changeDeveloperPay2FailStarted(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    /**
     *
     * @param orderId
     * @param consumerId
     * @param tableName
     * @return
     */
    public int changeDuibaPay2FailStarted(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);


}
