package cn.com.duiba.order.center.biz.dao.orderconsumer;

import cn.com.duiba.order.center.biz.entity.OrdersEntity;

import java.util.List;

import org.apache.ibatis.annotations.Param;

/**
 * Created by yansen on 16/9/22.
 */
public interface OrdersSimpleDao {

    /**
     *
     * @param id
     * @param tableName
     * @return
     */
	public OrdersEntity findById(@Param("id") Long id, @Param("tableName") String tableName);
	
	List<OrdersEntity> findByIds(
			@Param("ids") List<Long> ids, 
			@Param("tableName") String tableName);
	
	/**
	 * 按照sequence顺序查找多个订单
	 * @param ids
	 * @param tableName
	 * @param sequence
	 * @return
	 */
	List<OrdersEntity> findByIdsInSequence(
			@Param("ids") List<Long> ids, 
			@Param("tableName") String tableName,
			@Param("sequence") String sequence);

    /**
     *
     * @param orderNum
     * @param tableName
     * @return
     */
    public OrdersEntity findByOrderNum(@Param("orderNum") String orderNum, @Param("tableName") String tableName);

    /**
     *
     * @param orderId
     * @param consumerId
     * @param tableName
     * @return
     */
    public OrdersEntity select4updatelock(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    /**
     *
     * @param order
     * @return
     */
    public int insert(OrdersEntity order);

}
