package cn.com.duiba.order.center.biz.dao.orderconsumer;

import org.apache.ibatis.annotations.Param;

/**
 * Created by yansen on 16/9/22.
 */
public interface OrdersStatusChangeDao {

    /**
     *
     * @param orderId
     * @param consumerId
     * @param payStatus
     * @param tableName
     * @return
     */
    public Integer updatePayOrderStatus(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("payStatus") String payStatus, @Param("tableName") String tableName);

    /**
     *
     * @param orderId
     * @param consumerId
     * @param tableName
     * @return
     */
    public Integer doMakeConsumeSuccess(@Param("orderId")Long orderId,  @Param("consumerId")Long consumerId, @Param("tableName") String tableName);

    /**
     *
     * @param orderId
     * @param consumerId
     * @param failType
     * @param error4consumer
     * @param error4developer
     * @param error4admin
     * @param tableName
     * @return
     */
    public Integer doMakeConsumeFail(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("failType") Integer failType, @Param("error4consumer") String error4consumer, @Param("error4developer") String error4developer, @Param("error4admin") String error4admin, @Param("tableName") String tableName);

    /**加钱购支付成功 后 更新加钱购支付状态  为  pay_success
     * @param orderId
     * @param consumerId
     * @param tableName
     * @return
     */
    public Integer doAmbConsumerPayStatusPaySuccess(@Param("orderId")Long orderId,@Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    /**
     *
     * 使用where语句锁
     * 	where id=#{orderId} and audit_status='wait' and status='consume_success'
     * @param orderId
     * @param consumerId
     * @param tableName
     * @return
     */
    public int doAuditPass(@Param("orderId")Long orderId,@Param("consumerId") Long consumerId, @Param("tableName") String tableName);

    /**
     * 使用where语句锁
     * 	where id=#{orderId} and audit_status='wait' and status='consume_success'
     * @param orderId
     * @param consumerId
     * @param error4consumer
     * @param error4developer
     * @param error4admin
     * @param failType
     * @param tableName
     * @return
     */
    public int doAuditReject(@Param("orderId")Long orderId,@Param("consumerId") Long consumerId,@Param("error4consumer") String error4consumer,@Param("error4developer") String error4developer,@Param("error4admin") String error4admin,@Param("failType") Integer failType, @Param("tableName") String tableName);

    /**
     *
     * @param orderId
     * @param consumerId
     * @param payStatus
     * @param duibaPayStatus
     * @param consumerPayStatus
     * @param tableName
     * @return
     */
    public int doMakeSuccess(@Param("orderId")Long orderId,@Param("consumerId") Long consumerId,@Param("payStatus") String payStatus,@Param("duibaPayStatus") String duibaPayStatus,@Param("consumerPayStatus") String consumerPayStatus, @Param("tableName") String tableName) ;

    /**
     * where id=#{orderId} and status!='success' and status!='fail'
     * payStatus  如果null, 动态SQL不更新字段。
     * duibaPayStatus 如果为null,  动态SQL不更新字段。
     * consumerPayStatus 如果为null,动态SQL不更新字段
     * @param orderId
     * @param consumerId
     * @param payStatus
     * @param duibaPayStatus
     * @param consumerPayStatus
     * @param consumerPaybackPrice
     * @param tableName
     * @return
     */
    public int doMakeFail(@Param("orderId")Long orderId, @Param("consumerId")Long consumerId, @Param("payStatus")String payStatus,@Param("duibaPayStatus")String duibaPayStatus,@Param("consumerPayStatus")String consumerPayStatus,@Param("consumerPaybackPrice") Long consumerPaybackPrice,@Param("tableName") String tableName);

    /**
     *
     * @param orderId
     * @param consumerId
     * @param duibaPayStatus
     * @param tableName
     * @return
     */
    public Integer updateDuibaPayOrderStatus(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId, @Param("duibaPayStatus") String duibaPayStatus,@Param("tableName") String tableName);

    /**
     * 更新重填字段，只能使用一次
     * @param orderId
     * @param supplierOrderId
     * @param bizParams
     * @param brief
     * @return
     */
    public Integer doUpdateAllowInputUsed(@Param("orderId")Long orderId,@Param("consumerId") Long consumerId,@Param("supplierOrderId") Long supplierOrderId,@Param("bizParams") String bizParams,@Param("brief") String brief,@Param("tableName") String tableName);

    /**
     *
     * @param orderId
     * @param consumerId
     * @param supplierOrderId
     * @param bizParams
     * @param tableName
     * @return
     */
    public Integer doUpdateAllowInputUsed4Object(@Param("orderId") Long orderId,@Param("consumerId") Long consumerId, @Param("supplierOrderId")Long supplierOrderId,@Param("bizParams") String bizParams,@Param("tableName") String tableName);

    /**
     *
     * @param orderId
     * @param consumerId
     * @return
     */
    public Integer doAmbStatusAfterSend(@Param("orderId")Long orderId,@Param("consumerId") Long consumerId,@Param("tableName") String tableName);

}
