package cn.com.duiba.order.center.biz.dao.orderconsumer;

import org.apache.ibatis.annotations.Param;

import java.util.Date;

/**
 * Created by yansen on 16/9/27.
 */
public interface OrdersTextChangeDao {

    /**
     * 更新订单错误信息，状态，错误类型
     * @param orderId
     * @param consumerId
     * @param failType
     * @param errorMessage
     * @param error4Consumer
     * @param error4Developer
     * @param error4Admin
     * @param tableName
     * @return
     */
    public Integer updateErrorMessageAndFailType(@Param("orderId") Long orderId,@Param("consumerId") Long consumerId,@Param("failType") Integer failType, @Param("errorMessage") String errorMessage,
                                                 @Param("error4Consumer") String error4Consumer,@Param("error4Developer") String error4Developer,@Param("error4Admin") String error4Admin, @Param("tableName") String tableName);

    /**
     * 更新最后发送时间
     * @param orderId
     * @param consumerId
     * @param lastSendTime
     * @param tableName
     * @return
     */
    public Integer updateLastSendTime(@Param("orderId")Long orderId,@Param("consumerId") Long consumerId,@Param("lastSendTime") Date lastSendTime, @Param("tableName") String tableName);

    /**
     * 更新开发者订单号
     * @param orderId
     * @param consumerId
     * @param developBizId
     * @param tableName
     * @return
     */
    public Integer updateDevelopBizId(@Param("orderId")Long orderId,@Param("consumerId") Long consumerId,@Param("developBizId") String developBizId,@Param("tableName") String tableName);

    /**
     * 更新上游订单
     * @param orderId
     * @param consumerId
     * @param supplierOrderId
     * @param tableName
     * @return
     */
    public Integer updateSupplierOrderId(@Param("orderId")Long orderId,@Param("consumerId") Long consumerId,@Param("supplierOrderId") Long supplierOrderId,@Param("tableName") String tableName);

    /**
     * 释放一张优惠券
     * @param orderId
     * @param consumerId
     * @param tableName
     * @return
     */
    public Integer releaseCouponByOrderId(@Param("orderId") Long orderId, @Param("consumerId") Long consumerId,@Param("tableName") String tableName);

    /**
     * 下订单,更新优惠券ID
     * @param orderId
     * @param consumerId
     * @param couponId
     * @param tableName
     * @return
     */
    public Integer updateCouponId(@Param("orderId") Long orderId,@Param("consumerId") Long consumerId,@Param("couponId") Long couponId,@Param("tableName") String tableName);

    /**
     *
     * @param orderId
     * @param consumerId
     * @param subId
     * @param tableName
     * @return
     */
    public int updateSubOrderIdById(@Param("orderId") Long orderId,@Param("consumerId") Long consumerId,@Param("subId") Long subId,@Param("tableName") String tableName) ;
}
