package cn.com.duiba.order.center.biz.exchangecreator;

import cn.com.duiba.order.center.api.dto.OrdersDto;
import cn.com.duiba.order.center.biz.entity.AmbSubOrdersEntity;
import cn.com.duiba.order.center.biz.entity.OrdersEntity;
import cn.com.duiba.order.center.biz.handle.MainOrderSimpleHandle;
import cn.com.duiba.order.center.biz.service.message.OnsMessageService;
import cn.com.duiba.order.center.biz.tool.TimeProfile;
import cn.com.duiba.service.exception.BusinessException;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 普通兑换下单基础类
 * @author zhaodongxue
 *
 */
public class BaseCreator {
	@Autowired
	protected OnsMessageService onsMessageService;
	
	@Autowired
	private MainOrderSimpleHandle mainOrderSimpleHandle;

	protected void takeOrder(OrdersEntity order) throws Exception{
		takeOrder(order,null);
	}
	
	protected void takeOrder(OrdersEntity order,AmbSubOrdersEntity ambSubOrdersEntity) throws Exception{
		try {
			TimeProfile.enter("insertOrder");
			if(order.getId()!=null){
				throw new BusinessException("订单已经有主键id，无法创建");
			}
			
			if(isFree(order)){
				mainOrderSimpleHandle.takeOrderFree(order);
			}else if(isDuibaTakeMoney(order)){
				mainOrderSimpleHandle.takeOrderDuibaTakeMOney(order);
			}else if(isTakeMoney(order)){
				mainOrderSimpleHandle.takeOrderTakeMoney(order);
			}else if(isConsumerPay(order)){
				mainOrderSimpleHandle.takeOrderConsumerPay(order,ambSubOrdersEntity);
			}else{
				throw new BusinessException("扣费价格不正确");
			}
		} finally {
			TimeProfile.release();
		}
	}

	/**
	 * 平台券下单方法
	 *
	 * @author xuhengfei
	 * @param order
	 * @return
	 * @throws Exception
	 * @since JDK 1.6
	 */
	protected OrdersEntity takePcgOrder(OrdersEntity order) throws BusinessException{
		try {
			TimeProfile.enter("takeOrderIntimes");
			if(order.getId()!=null){
				throw new BusinessException("订单已经有主键id，无法创建");
			}
			if(isFree(order)){
				mainOrderSimpleHandle.takeOrderFree(order);
			}else if(isDuibaTakeMoney(order)){
				//表示兑吧去扣费
				throw new BusinessException("暂不支持");
			}else if(isTakeMoney(order)){
				throw new BusinessException("暂不支持");
			}else if(isConsumerPay(order)){
				//加钱购
				throw new BusinessException("暂不支持");
			}else{
				throw new BusinessException("扣费价格不正确");
			}
			if(order.getId()!=null){
				order=mainOrderSimpleHandle.findById(order.getId(), order.getConsumerId());
				if(order==null){
					throw new BusinessException("订单没有创建");
				}
				return order;
			}else{
				throw new BusinessException("订单没有创建");
			}
		}finally {
			TimeProfile.release();
		}
	}
	
	/**
	 * 是否免费
	 * @param order
	 * @return
	 */
	private boolean isFree(OrdersEntity order){
		if(order.getActualPrice()==0 && order.getDuibaActualPrice()==0 && order.getConsumerPayPrice()==0){
			return true;
		}
		return false;
	}
	
	/**
	 * 是否兑吧扣钱
	 * @param order
	 * @return
	 */
	private boolean isDuibaTakeMoney(OrdersEntity order){
		if(order.getActualPrice()==0 && order.getDuibaActualPrice()>0 &&order.getConsumerPayPrice()==0){
			return true;
		}
		return false;
	}
	
	/**
	 * 是否扣钱
	 * @param order
	 * @return
	 */
	private boolean isTakeMoney(OrdersEntity order){
		if(order.getActualPrice()>0 && order.getDuibaActualPrice()==0 && order.getConsumerPayPrice()==0){
			return true;
		}
		return false;
	}
	
	/**
	 * 是否消费者加钱购
	 * @param order
	 * @return
	 */
	private boolean isConsumerPay(OrdersEntity order){
		if(order.getActualPrice()==0 && order.getDuibaActualPrice()==0&& order.getConsumerPayPrice()>0){
			return true;
		}
		return false;
	}
	
	/**
	 * 是否需要审核
	 * @param auditPricePerConsumer 用户单笔免审核上限
	 * @param actualPrice 商品实际价格
	 * @param chargeMode 兑换方式
	 * @return
	 */
	protected boolean isNeedAudit(Integer auditPricePerConsumer, int actualPrice , String chargeMode){
		// 如果是api请求，无须审核
		if (OrdersDto.ChargeModeApi.equals(chargeMode)) {
			return false;
		}
		//如果是大转盘领奖，无须审核
		if(OrdersDto.ChargeModeTurntable.equals(chargeMode)){
			return false;
		}
		
		if(auditPricePerConsumer == null){
			return false;
		}
		
		if (actualPrice >= auditPricePerConsumer && actualPrice > 0) {
			return true;
		} else {
			return false;
		}
	}

}
