package cn.com.duiba.order.center.biz.exchangecreator;

import org.springframework.stereotype.Component;

import cn.com.duiba.order.center.api.dto.OrderCreateContext;
import cn.com.duiba.order.center.api.dto.RequestParams;
import cn.com.duiba.order.center.biz.constant.OnsTopicConstant;
import cn.com.duiba.order.center.biz.entity.OrdersEntity;
import cn.com.duiba.service.exception.BusinessException;

/**
 * QB订单创建
 */
@Component
public class QBcreator extends BaseCreator {

//	@Autowired
//	private TopicConstant topicConstant;
//	@Autowired
//	private MessageService messageService;
	
	/**
	 * Q币普通兑换下单操作
	 * @param order 订单对象
	 * @param supplierProductId Q币供应商id
	 * @param params http参数
	 * @throws Exception
	 */
	public void createOrder(OrdersEntity order,Long supplierProductId, RequestParams params) throws Exception{
		
		if(order == null){
			throw new BusinessException("订单为空");
		}
		
		// 创建订单
		takeOrder(order);
		
		// 订单异步处理消息
		OrderCreateContext orderCreateContext = new OrderCreateContext();
		orderCreateContext.setOrderId(order.getId());
		orderCreateContext.setConsumerId(order.getConsumerId());
		orderCreateContext.setParams(params);
		orderCreateContext.setChargeMode(order.getChargeMode());
		orderCreateContext.setSupplierProductId(supplierProductId);
		orderCreateContext.setTimestamp(System.currentTimeMillis());
		onsMessageService.sendOrderCreateMsg(OnsTopicConstant.QB_CREATE_TAG, orderCreateContext);
//		messageService.sendMsg(topicConstant.getQbOrderCreatePart(), JSONObject.toJSONString(orderCreateContext));
	}

}
