package cn.com.duiba.order.center.biz.exchangecreator;

import org.springframework.stereotype.Component;

import cn.com.duiba.order.center.api.dto.OrderCreateContext;
import cn.com.duiba.order.center.api.dto.RequestParams;
import cn.com.duiba.order.center.biz.constant.OnsTopicConstant;
import cn.com.duiba.order.center.biz.entity.AmbSubOrdersEntity;
import cn.com.duiba.order.center.biz.entity.OrdersEntity;

/**
 * 虚拟商品订单创建
 * Created by yansen on 16/11/23.
 */
@Component
public class VirtualCreator extends BaseCreator{


//    @Autowired
//    private TopicConstant topicConstant;
//    @Autowired
//    private MessageService messageService;
    
    /**
     *
     * @param order 订单对象
     * @param ambSubOrdersEntity 加钱购子订单对象
     * @param params http参数
     * @throws Exception
     */
    public void createOrder(OrdersEntity order, AmbSubOrdersEntity ambSubOrdersEntity,String degreeStr ,RequestParams params) throws Exception {
        if(order == null){
            throw new Exception("订单为空");
        }
        takeOrder(order,ambSubOrdersEntity);
        OrderCreateContext orderCreateContext = new OrderCreateContext();
        orderCreateContext.setOrderId(order.getId());
        orderCreateContext.setConsumerId(order.getConsumerId());
        orderCreateContext.setParams(params);
        orderCreateContext.setChargeMode(order.getChargeMode());
        orderCreateContext.setTimestamp(System.currentTimeMillis());
        orderCreateContext.addAParam("degreeStr", degreeStr);
        
        onsMessageService.sendOrderCreateMsg(OnsTopicConstant.VIRTUAL_CREATE_TAG, orderCreateContext);
//        messageService.sendMsg(topicConstant.getVirtualOrderCreatePart(), JSONObject.toJSONString(orderCreateContext));
    }
}
