package cn.com.duiba.order.center.biz.handle;

import cn.com.duiba.order.center.biz.dao.BaseOrderTool;
import cn.com.duiba.order.center.biz.dao.orderconsumer.OrdersStatusChangeDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;


/**
 * Created by yansen on 16/9/22.
 */
@Component
public class OrdersStatusChangeHandle {

    @Autowired
    private OrdersStatusChangeDao ordersStatusChangeDao;

    /**
     *
     * @param orderId
     * @param consumerId
     * @param payStatus
     * @return
     */
    public Integer updatePayOrderStatus(Long orderId, Long consumerId, String payStatus){
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return ordersStatusChangeDao.updatePayOrderStatus(orderId,consumerId,payStatus,tableName);
    }

    /**
     *
     * @param orderId
     * @param consumerId
     * @return
     */
    public Integer doMakeConsumeSuccess(Long orderId, Long consumerId){
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return ordersStatusChangeDao.doMakeConsumeSuccess(orderId,consumerId,tableName);
    }

    /**
     *
     * @param orderId
     * @param consumerId
     * @param failType
     * @param error4consumer
     * @param error4developer
     * @param error4admin
     * @return
     */
    public Integer doMakeConsumeFail( Long orderId, Long consumerId, Integer failType,String error4consumer,String error4developer, String error4admin){
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return ordersStatusChangeDao.doMakeConsumeFail(orderId,consumerId,failType,error4consumer,error4developer,error4admin,tableName);
    }

    /**
     *
     * @param orderId
     * @param consumerId
     * @return
     */
    public Integer doAmbConsumerPayStatusPaySuccess(Long orderId, Long consumerId){
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return ordersStatusChangeDao.doAmbConsumerPayStatusPaySuccess(orderId,consumerId,tableName);
    }

    /**
     *
     * @param orderId
     * @param consumerId
     * @return
     */
    public Integer doAuditPass(Long orderId,Long consumerId){
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return ordersStatusChangeDao.doAuditPass(orderId,consumerId,tableName);
    }

    /**
     *
     * @param orderId
     * @param consumerId
     * @param error4consumer
     * @param error4developer
     * @param error4admin
     * @param failType
     * @return
     */
    public Integer doAuditReject(Long orderId, Long consumerId, String error4consumer, String error4developer, String error4admin, Integer failType){
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return ordersStatusChangeDao.doAuditReject(orderId,consumerId,error4consumer,error4developer,error4admin,failType,tableName);
    }

    /**
     *
     * @param orderId
     * @param consumerId
     * @param payStatus
     * @param duibaPayStatus
     * @param consumerPayStatus
     * @return
     */
    public Integer doMakeSuccess(Long orderId,Long consumerId,String payStatus,String duibaPayStatus,String consumerPayStatus) {
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return ordersStatusChangeDao.doMakeSuccess(orderId,consumerId,payStatus,duibaPayStatus,consumerPayStatus,tableName);
    }

    /**
     *
     * @param orderId
     * @param consumerId
     * @param payStatus
     * @param duibaPayStatus
     * @param consumerPayStatus
     * @param consumerPaybackPrice
     * @return
     */
    public Integer doMakeFail(Long orderId, Long consumerId, String payStatus, String duibaPayStatus, String consumerPayStatus, Long consumerPaybackPrice) {
        String tableName = BaseOrderTool.getTableNameStr(consumerId);
        return ordersStatusChangeDao.doMakeFail(orderId,consumerId,payStatus,duibaPayStatus,consumerPayStatus,consumerPaybackPrice,tableName);
    }

    /**
     *
     * @param orderId
     * @param consumerId
     * @param duibaPayStatus
     * @return
     */
    public Integer updateDuibaPayOrderStatus(Long orderId,Long consumerId,String duibaPayStatus){
        String tableName= BaseOrderTool.getTableNameStr(consumerId);
        return ordersStatusChangeDao.updateDuibaPayOrderStatus(orderId,consumerId,duibaPayStatus,tableName);
    }

    /**
     *
     * @param orderId
     * @param consumerId
     * @param supplierOrderId
     * @param bizParams
     * @param brief
     * @return
     */
    public Integer doUpdateAllowInputUsed(Long orderId, Long consumerId, Long supplierOrderId, String bizParams, String brief){
        String tableName= BaseOrderTool.getTableNameStr(consumerId);
        return ordersStatusChangeDao.doUpdateAllowInputUsed(orderId,consumerId,supplierOrderId,bizParams,brief,tableName);
    }

    /**
     *
     * @param orderId
     * @param consumerId
     * @param supplierOrderId
     * @param bizParams
     * @return
     */
    public Integer doUpdateAllowInputUsed4Object(Long orderId,Long consumerId,Long supplierOrderId,String bizParams){
        String tableName= BaseOrderTool.getTableNameStr(consumerId);
        return ordersStatusChangeDao.doUpdateAllowInputUsed4Object(orderId,consumerId,supplierOrderId,bizParams,tableName);
    }

    /**
     *
     * @param orderId
     * @param consumerId
     * @return
     */
    public Integer doAmbStatusAfterSend(Long orderId,Long consumerId){
        String tableName= BaseOrderTool.getTableNameStr(consumerId);
        return ordersStatusChangeDao.doAmbStatusAfterSend(orderId,consumerId,tableName);
    }
}
