package cn.com.duiba.order.center.biz.remoteservice;

import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import org.slf4j.LoggerFactory;
import cn.com.duiba.order.center.api.dto.ConsumerLimitRecordDto;
import cn.com.duiba.order.center.api.remoteservice.RemoteConsumerExchangeLimitService;
import cn.com.duiba.order.center.biz.service.credits.ConsumerLimitRecordOnlyService;
import cn.com.duiba.wolf.dubbo.DubboResult;

@Service
public class RemoteConsumerExchangeLimitServiceImpl implements RemoteConsumerExchangeLimitService {
	
	private static final Logger log = LoggerFactory.getLogger(RemoteConsumerExchangeLimitServiceImpl.class);

	@Autowired
	private ConsumerLimitRecordOnlyService consumerExchangeLimitService;
	
	@Override
	public DubboResult<Integer> consumerLimitRecordOnlyInsert(ConsumerLimitRecordDto record) {
		try {
			Integer ret = consumerExchangeLimitService.consumerLimitRecordOnlyInsert(record);
			return DubboResult.successResult(ret);
		} catch (Exception e) {
			log.warn("永久兑换一次，违反唯一索引", e);
			return DubboResult.failResult(e.getMessage());
		}
	}
	
	@Override
	public DubboResult<Integer> consumerLimitRecordOnlyDelete(Long consumerId, Long appItemId, Long itemId, Long orderId) {
		Integer ret = consumerExchangeLimitService.consumerLimitRecordOnlyDelete(consumerId, appItemId, itemId, orderId);
		return DubboResult.successResult(ret);
	}

}
