package cn.com.duiba.order.center.biz.remoteservice;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.order.center.api.dto.OrdersDto;
import cn.com.duiba.order.center.api.remoteservice.RemoteMirrorOrderSimpleService;
import cn.com.duiba.order.center.biz.entity.OrdersEntity;
import cn.com.duiba.order.center.biz.service.mainorder.orderapp.MirrorOrderSimpleService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;

@Service
public class RemoteMirrorOrderSimpleServiceImpl implements RemoteMirrorOrderSimpleService {

	@Autowired
	private MirrorOrderSimpleService mirrorOrderSimpleService;
	
//	@Override
//	public DubboResult<Boolean> insert(OrdersDto order) {
//		OrdersEntity entity = BeanUtils.copy(order, OrdersEntity.class);
//		int flag = mirrorOrderSimpleService.insert(entity);
//		if(flag < 0){
//			return DubboResult.failResult("app维度订单添加记录失败");
//		}
//		return DubboResult.successResult(true);
//	}

	@Override
	public DubboResult<List<OrdersDto>> findByOrderNums(List<String> orderNums, Long appId) {
		List<OrdersEntity> ret = mirrorOrderSimpleService.findByOrderNums(orderNums, appId);
		List<OrdersDto> dtos = new ArrayList<>();
		for(OrdersEntity entity : ret){
			OrdersDto dto = BeanUtils.copy(entity, OrdersDto.class);
			dtos.add(dto);
		}
		return DubboResult.successResult(dtos);
	}

//	@Override
//	public DubboResult<OrdersDto> findByOrderNum(String orderNum, Long appId) {
//		OrdersEntity entity = mirrorOrderSimpleService.findByOrderNum(orderNum, appId);
//		OrdersDto dto = BeanUtils.copy(entity, OrdersDto.class);
//		return DubboResult.successResult(dto);
//	}

}
