package cn.com.duiba.order.center.biz.remoteservice;

import cn.com.duiba.order.center.api.dto.OrdersDto;
import cn.com.duiba.order.center.api.remoteservice.RemoteOrderHouseSimpleService;
import cn.com.duiba.order.center.biz.service.mainorder.orderhouse.OrderHouseSimpleService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by yansen on 16/9/22.
 */
@Service
public class RemoteOrderHouseSimpleServiceImpl implements RemoteOrderHouseSimpleService {

    @Autowired
    private OrderHouseSimpleService orderHouseSimpleService;
    @Override
    public DubboResult<OrdersDto> findByOrderNum(String orderNum) {
        return DubboResult.successResult(orderHouseSimpleService.findByOrderNum(orderNum));
    }

    @Override
    public DubboResult<OrdersDto> findById(Long id) {
        return DubboResult.successResult(orderHouseSimpleService.findById(id));
    }

    @Override
    public DubboResult<List<OrdersDto>> findAllByIds(List<Long> ids) {
        return DubboResult.successResult(orderHouseSimpleService.findAllByIds(ids));
    }

    @Override
    public DubboResult<List<OrdersDto>> tempSearch(String startTime, String endTime) {
        return DubboResult.successResult(orderHouseSimpleService.tempSearch(startTime,endTime));
    }

}
