package cn.com.duiba.order.center.biz.remoteservice;

import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import org.slf4j.LoggerFactory;
import cn.com.duiba.order.center.api.remoteservice.RemoteOrderJumpService;
import cn.com.duiba.order.center.biz.service.mainorder.orderconsumer.OrderJumpService;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.wolf.dubbo.DubboResult;


/**
 * Created by yansen on 16/9/21.
 */
@Service
public class RemoteOrderJumpServiceImpl implements RemoteOrderJumpService {

    private static Logger log = LoggerFactory.getLogger(RemoteOrderJumpService.class);

    @Autowired
    private OrderJumpService orderJumpService;

    /**
     * 创建订单started->兑吧付款complete
     *
     * @param orderId
     * @param consumerId
     */
    @Override
    public DubboResult<Integer> jumpCreateStarted2DuibaPayComplete(Long orderId, Long consumerId) {
        try {
            int ret=orderJumpService.jumpCreateStarted2DuibaPayComplete(orderId,consumerId);
            return DubboResult.successResult(ret);
        } catch (BusinessException e) {
            log.error("jumpCreateStarted2DuibaPayComplete",e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    /**
     * 创建订单started->开发都付款完成 complete
     *
     * @param orderId
     * @param consumerId
     */
    @Override
    public DubboResult<Integer> jumpCreateStarted2DeveloperPayComplete(Long orderId, Long consumerId) {
        try {
            int ret=orderJumpService.jumpCreateStarted2DeveloperPayComplete(orderId,consumerId);
            return DubboResult.successResult(ret);
        } catch (BusinessException e) {
            log.error("jumpCreateStarted2DeveloperPayComplete",e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    /**
     * 开发者付款  started-> 兑吧付款完成 complete
     *
     * @param orderId
     * @param consumerId
     */
    @Override
    public DubboResult<Integer> jumpDeveloperPayStarted2DuibaPayComplete(Long orderId, Long consumerId) {
        try {
            int ret=orderJumpService.jumpDeveloperPayStarted2DuibaPayComplete(orderId,consumerId);
            return DubboResult.successResult(ret);
        } catch (BusinessException e) {
            log.error("jumpDeveloperPayStarted2DuibaPayComplete",e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    /**
     * 扣积分started->用户付款complete
     *
     * @param orderId
     * @param consumerId
     */
    @Override
    public DubboResult<Integer> jumpConsumeCreditsStarted2ConsumerPayComplete(Long orderId, Long consumerId) {
        try {
            int ret=orderJumpService.jumpConsumeCreditsStarted2ConsumerPayComplete(orderId,consumerId);
            return DubboResult.successResult(ret);
        } catch (BusinessException e) {
            log.error("jumpConsumeCreditsStarted2ConsumerPayComplete",e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    /**
     * 扣积分started->审核complete
     *
     * @param orderId
     * @param consumerId
     */
    @Override
    public DubboResult<Integer> jumpConsumeCreditsStarted2AuditComplete(Long orderId, Long consumerId) {
        try {
            int ret=orderJumpService.jumpConsumeCreditsStarted2AuditComplete(orderId,consumerId);
            return DubboResult.successResult(ret);
        } catch (BusinessException e) {
            log.error("jumpConsumeCreditsStarted2AuditComplete",e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    /**
     * 上游兑换started->售后complete
     *
     * @param orderId
     * @param consumerId
     */
    @Override
    public DubboResult<Integer> jumpSupplierExchangeStarted2AfterSendComplete(Long orderId, Long consumerId) {
        try {
            int ret=orderJumpService.jumpSupplierExchangeStarted2AfterSendComplete(orderId,consumerId);
            return DubboResult.successResult(ret);
        } catch (BusinessException e) {
            log.error("jumpSupplierExchangeStarted2AfterSendComplete",e);
            return DubboResult.failResult(e.getMessage());
        }
    }
}
