package cn.com.duiba.order.center.biz.remoteservice;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.order.center.api.dto.OrdersExtraDto;
import cn.com.duiba.order.center.api.remoteservice.RemoteOrdersExtraService;
import cn.com.duiba.order.center.biz.entity.OrdersExtraEntity;
import cn.com.duiba.order.center.biz.service.credits.OrdersExtraService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;

/**
 * Created by yansen on 16/9/24.
 */
@Service
public class RemoteOrdersExtraServiceImpl implements RemoteOrdersExtraService {

    @Autowired
    private OrdersExtraService ordersExtraService;
    @Override
    public DubboResult<OrdersExtraDto> insert(OrdersExtraDto ordersExtra) {
         ordersExtraService.insert(ordersExtra);
        return DubboResult.successResult(ordersExtra);
    }

    @Override
    public DubboResult<Void> updateAgentAndTransfer(Long id, String userAgent, String transfer) {
        ordersExtraService.updateAgentAndTransfer(id,userAgent,transfer);
        return DubboResult.successResult(null);
    }

	@Override
	public DubboResult<OrdersExtraDto> findByOrderIdAndType(Long orderId, String orderType) {
		OrdersExtraEntity ent = ordersExtraService.findByOrderIdAndType(orderId, orderType);
        OrdersExtraDto dto = BeanUtils.copy(ent, OrdersExtraDto.class);
        return DubboResult.successResult(dto);
	}
}
