package cn.com.duiba.order.center.biz.remoteservice;

import cn.com.duiba.order.center.api.remoteservice.RemoteOrdersStatusChangeService;
import cn.com.duiba.order.center.biz.service.mainorder.orderconsumer.OrdersStatusChangeService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created by yansen on 16/9/22.
 */
@Service
public class RemoteOrdersStatusChangeServiceImpl implements RemoteOrdersStatusChangeService {

    @Autowired
    private OrdersStatusChangeService ordersStatusChangeService;
    @Override
    public DubboResult<Integer> updatePayOrderStatus(Long orderId, Long consumerId, String payStatus) {
        return DubboResult.successResult(ordersStatusChangeService.updatePayOrderStatus(orderId,consumerId,payStatus));
    }

    /**
     * 扣积分成功，订单状态变更
     *
     * @param orderId
     * @param consumerId
     * @return
     */
    @Override
    public DubboResult<Integer> doMakeConsumeSuccess(Long orderId, Long consumerId) {
        return DubboResult.successResult(ordersStatusChangeService.doMakeConsumeSuccess(orderId,consumerId));
    }


    @Override
    public DubboResult<Integer> doMakeConsumeFail(Long orderId, Long consumerId, Integer failType, String error4consumer, String error4developer, String error4admin) {
        return DubboResult.successResult(ordersStatusChangeService.doMakeConsumeFail(orderId,consumerId,failType,error4consumer,error4developer,error4admin));
    }

    /**
     * 加钱购支付成功 后 更新加钱购支付状态  为  pay_success
     *
     * @param orderId
     * @param consumerId
     **/
    @Override
    public DubboResult<Integer> doAmbConsumerPayStatusPaySuccess(Long orderId, Long consumerId) {
        return DubboResult.successResult(ordersStatusChangeService.doAmbConsumerPayStatusPaySuccess(orderId,consumerId));
    }

    @Override
    public DubboResult<Integer> doAuditPass(Long orderId, Long consumerId) {
        return DubboResult.successResult(ordersStatusChangeService.doAuditPass(orderId,consumerId));
    }

    @Override
    public DubboResult<Integer> doAuditReject(Long orderId, Long consumerId, String error4consumer, String error4developer, String error4admin, Integer failType) {
        return DubboResult.successResult(ordersStatusChangeService.doAuditReject(orderId,consumerId,error4consumer,error4developer,error4admin,failType));
    }

    @Override
    public DubboResult<Integer> doMakeSuccess(Long orderId, Long consumerId, String payStatus, String duibaPayStatus, String consumerPayStatus) {
        return DubboResult.successResult(ordersStatusChangeService.doMakeSuccess(orderId,consumerId,payStatus,duibaPayStatus,consumerPayStatus));
    }

    @Override
    public DubboResult<Integer> doMakeFail(Long orderId, Long consumerId, String payStatus, String duibaPayStatus, String consumerPayStatus, Long consumerPaybackPrice) {
        return DubboResult.successResult(ordersStatusChangeService.doMakeFail(orderId,consumerId,payStatus,duibaPayStatus,consumerPayStatus,consumerPaybackPrice));
    }

    @Override
    public DubboResult<Integer> updateDuibaPayOrderStatus(Long orderId, Long consumerId, String duibaPayStatus) {
        return DubboResult.successResult(ordersStatusChangeService.updateDuibaPayOrderStatus(orderId,consumerId,duibaPayStatus));
    }

    @Override
    public DubboResult<Integer> doUpdateAllowInputUsed(Long orderId, Long consumerId, Long supplierOrderId, String bizParams, String brief) {
        return DubboResult.successResult(ordersStatusChangeService.doUpdateAllowInputUsed(orderId,consumerId,supplierOrderId,bizParams,brief));
    }
}
