package cn.com.duiba.order.center.biz.remoteservice;

import cn.com.duiba.order.center.api.dto.SupplierOrderDto;
import cn.com.duiba.order.center.api.remoteservice.RemoteSupplierOrdersService;
import cn.com.duiba.order.center.biz.service.credits.SupplierOrdersService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by yansen on 16/9/26.
 */
@Service
public class RemoteSupplierOrdersServiceImpl implements RemoteSupplierOrdersService {

    @Autowired
    private SupplierOrdersService supplierOrdersService;
    @Override
    public DubboResult<SupplierOrderDto> insert(SupplierOrderDto supplierOrderDto) {
        return DubboResult.successResult(supplierOrdersService.insert(supplierOrderDto));
    }

    @Override
    public DubboResult<Void> update(SupplierOrderDto supplierOrderDto) {
        supplierOrdersService.update(supplierOrderDto);
        return DubboResult.successResult(null);
    }

    @Override
    public DubboResult<SupplierOrderDto> find(Long id) {
        return DubboResult.successResult(supplierOrdersService.find(id));
    }

    @Override
    public DubboResult<List<SupplierOrderDto>> findAllByDuibaOrderNum(String duibaOrderNum) {
        return DubboResult.successResult(supplierOrdersService.findAllByDuibaOrderNum(duibaOrderNum));
    }

    @Override
    public DubboResult<SupplierOrderDto> findByDuibaOrderNum(String duibaOrderNum) {
        return DubboResult.successResult(supplierOrdersService.findByDuibaOrderNum(duibaOrderNum));
    }

    @Override
    public DubboResult<Integer> tempDeleteRecord(Long id) {
        return DubboResult.successResult(supplierOrdersService.tempDeleteRecord(id));
    }

    @Override
    public DubboResult<List<SupplierOrderDto>> findAllByOrderId(Long orderId) {
        return DubboResult.successResult(supplierOrdersService.findAllByOrderId(orderId));
    }


}
