package cn.com.duiba.order.center.biz.service.activity;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import cn.com.duiba.order.center.biz.constant.TopicConstant;
import cn.com.duiba.order.center.biz.service.message.MessageService;

/**
 * 活动订单数据同步服务
 * @author zdx
 *
 */
@Repository("dataSyncActivityOrderService")
public class DataSyncActivityOrderService  {
	
	
	@Autowired
	private MessageService messageService;
	@Autowired
	private TopicConstant topicConstant;

	/**
	 * 通过订单号同步数据<br/>
	 * 存在更新不存在新增
	 * 
	 * @param orderNum
	 */
	public void dataSync(String orderNum) {
		messageService.sendMsg(topicConstant.getTopicActivityOrderDataSync(), orderNum);
	}

}
