package cn.com.duiba.order.center.biz.service.credits;

import cn.com.duiba.order.center.api.dto.AlipayBatchLogDto;
import cn.com.duiba.order.center.biz.dao.credits.AlipayBatchLogDao;
import cn.com.duiba.order.center.biz.entity.AlipayBatchLogEntity;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created by yansen on 16/10/26.
 * 支付宝批量付款记录表
 */
@Service
public class AlipayBatchLogService {

    @Autowired
    private AlipayBatchLogDao alipayBatchLogDao;

    /**
     *
     * @param alipayBatchLogDto
     * @return
     */
    public AlipayBatchLogDto insert(AlipayBatchLogDto alipayBatchLogDto){
        AlipayBatchLogEntity entity= BeanUtils.copy(alipayBatchLogDto,AlipayBatchLogEntity.class);
        alipayBatchLogDao.insert(entity);
        alipayBatchLogDto.setId(entity.getId());
        return alipayBatchLogDto;
    }

    /**
     *
     * @param alipayBatchLogDto
     * @return
     */
    public AlipayBatchLogDto update(AlipayBatchLogDto alipayBatchLogDto){
        AlipayBatchLogEntity entity= BeanUtils.copy(alipayBatchLogDto,AlipayBatchLogEntity.class);
        alipayBatchLogDao.update(entity);
        return alipayBatchLogDto;
    }

    /**
     *
     * @param batchNo
     * @return
     */
    public AlipayBatchLogDto findByBatchNo(String batchNo){
        return BeanUtils.copy(alipayBatchLogDao.findByBatchNo(batchNo),AlipayBatchLogDto.class);
    }
}
