package cn.com.duiba.order.center.biz.service.credits;

import cn.com.duiba.order.center.api.dto.AmbSubOrdersDto;
import cn.com.duiba.order.center.biz.dao.credits.AmbSubOrdersDao;
import cn.com.duiba.order.center.biz.entity.AmbSubOrdersEntity;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created by yansen on 16/9/26.
 */
@Service
public class AmbSubOrdersService {

    @Autowired
    private AmbSubOrdersDao ambSubOrdersDao;

    /**
     *
     * @param subId
     * @return
     */
    public int updateSettleStatusWaitSettleBySubId(Long subId) {
        return ambSubOrdersDao.updateSettleStatusWaitSettleBySubId(subId);
    }

    /**
     *
     * @param subId
     * @return
     */
    public AmbSubOrdersDto findSubOrderById(Long subId){
        return BeanUtils.copy(ambSubOrdersDao.findSubOrderById(subId),AmbSubOrdersDto.class);
    }

    /**
     *
     * @param subId
     * @return
     */
    public int updateSettleStatusSettleBySubId(Long subId){
        return ambSubOrdersDao.updateSettleStatusSettleBySubId(subId);
    }

    /**
     *
     * @param subId
     * @param remark
     * @return
     */
    public int updateRemarkBySubId(Long subId,String remark){
        return ambSubOrdersDao.updateRemarkBySubId(subId,remark);
    }

    /**
     *
     * @param subId
     * @param consumerPayBackPrice
     * @return
     */
    public int updateSettleStatusNoneBySubId(Long subId,Long consumerPayBackPrice){
        return ambSubOrdersDao.updateSettleStatusNoneBySubId(subId,consumerPayBackPrice);
    }

    /**
     *
     * @param subId
     * @return
     */
    public int updateShipStatus4ReceivedAtCreate(Long subId){
        return ambSubOrdersDao.updateShipStatus4ReceivedAtCreate(subId);
    }

    /**
     *
     * @param entity
     * @return
     */
    public AmbSubOrdersEntity createSubOrders(AmbSubOrdersEntity entity){
        ambSubOrdersDao.createSubOrders(entity);
        return entity;
    }

    /**
     *
     * @param subId
     * @return
     */
    public int updateShipStatus4WaitShip(Long subId){
        return ambSubOrdersDao.updateShipStatus4WaitShip(subId);
    }

    /**
     *
     * @param subId
     * @return
     */
    public int updateShipStatus4Shiped(Long subId){
        return ambSubOrdersDao.updateShipStatus4Shiped(subId);
    }
}
