package cn.com.duiba.order.center.biz.service.credits;

import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import org.slf4j.LoggerFactory;
import cn.com.duiba.order.center.api.dto.OrdersDto;
import cn.com.duiba.order.center.biz.dao.credits.MasterOrdersPayCenterExceptionDao;
import cn.com.duiba.order.center.biz.entity.OrdersBackupEntity;

/**
 * Created by yansen on 16/9/22.
 */
@Service
public class MasterOrdersPayCenterExceptionService {

	@Autowired
	private MasterOrdersPayCenterExceptionDao masterOrdersPayCenterExceptionDao;

	private static final Logger log = LoggerFactory.getLogger(MasterOrdersPayCenterExceptionService.class);

	/**
	 *
	 * @param order
	 * @param mes
	 */
	public void insert(OrdersDto order, String mes) {
		OrdersBackupEntity back = new OrdersBackupEntity();
		try {
			PropertyUtils.copyProperties(back, order);
			back.setOrderId(order.getId());
			back.setPayCenterMessage(mes);
			back.setId(null);

		} catch (Exception e) {
			log.error("插入失败", e);
		}
		masterOrdersPayCenterExceptionDao.insert(back);
	}
}
