package cn.com.duiba.order.center.biz.service.credits;

import cn.com.duiba.order.center.api.dto.OrdersFasterDto;
import cn.com.duiba.order.center.biz.dao.credits.OrdersFasterSimpleDao;
import cn.com.duiba.order.center.biz.entity.OrdersFasterEntity;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * Created by yansen on 16/9/23.
 */
@Service
public class OrdersFasterSimpleService {

    @Autowired
    private OrdersFasterSimpleDao ordersFasterSimpleDao;

    /**
     *
     * @param ordersFasterDto
     */
    public void insert(OrdersFasterDto ordersFasterDto){
        OrdersFasterEntity entity= BeanUtils.copy(ordersFasterDto,OrdersFasterEntity.class);
        ordersFasterSimpleDao.insert(entity);
        ordersFasterDto.setId(entity.getId());
    }

    /**
     *
     * @param orderId
     * @param fasterType
     * @return
     */
    public OrdersFasterDto findByOrderIdAndFastertype(Long orderId,Integer fasterType){
        return BeanUtils.copy(ordersFasterSimpleDao.findByOrderIdAndFastertype(orderId,fasterType),OrdersFasterDto.class);
    }

    /**
     *
     * @param id
     * @param lastSendTime
     * @return
     */
    public Integer updateLastSendTime(Long id, Date lastSendTime){
        return ordersFasterSimpleDao.updateLastSendTime(id,lastSendTime);
    }

    /**
     *
     * @param orderId
     * @param fasterType
     * @return
     */
    public Integer deleteOrderByOrderIdAndFasterType(Long orderId,Integer fasterType){
        return ordersFasterSimpleDao.deleteOrderByOrderIdAndFasterType(orderId,fasterType);
    }

    /**
     *
     * @param fasterType
     * @return
     */
    public List<OrdersFasterDto> findHuiChangeAndSuDuDaTimeOutOrder(Integer fasterType){
        return BeanUtils.copyList(ordersFasterSimpleDao.findHuiChangeAndSuDuDaTimeOutOrder(fasterType),OrdersFasterDto.class);
    }

    /**
     *
     * @param orderId
     */
    public void deleteOrderFast(Long orderId){
        ordersFasterSimpleDao.deleteOrderFast(orderId);
    }

}

