package cn.com.duiba.order.center.biz.service.credits;

import cn.com.duiba.order.center.api.dto.SupplierOrderDto;
import cn.com.duiba.order.center.biz.dao.credits.SupplierOrdersDao;
import cn.com.duiba.order.center.biz.entity.SupplierOrderEntity;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;


/**
 * Created by yansen on 16/9/26.
 */
@Service
public class SupplierOrdersService {

    @Autowired
    private SupplierOrdersDao supplierOrdersDao;

    /**
     *
     * @param supplierOrderDto
     * @return
     */
    public SupplierOrderDto insert(SupplierOrderDto supplierOrderDto){
        SupplierOrderEntity entity= BeanUtils.copy(supplierOrderDto,SupplierOrderEntity.class);
        supplierOrdersDao.insert(entity);
        supplierOrderDto.setId(entity.getId());
        return supplierOrderDto;
    }

    /**
     *
     * @param supplierOrderDto
     */
    public void update(SupplierOrderDto supplierOrderDto){
        SupplierOrderEntity entity= BeanUtils.copy(supplierOrderDto,SupplierOrderEntity.class);
        supplierOrdersDao.update(entity);
    }

    /**
     *
     * @param id
     * @return
     */
    public SupplierOrderDto find(Long id){
        return BeanUtils.copy(supplierOrdersDao.find(id),SupplierOrderDto.class);
    }

    /**
     *
     * @param duibaOrderNum
     * @return
     */
    public List<SupplierOrderDto> findAllByDuibaOrderNum(String duibaOrderNum){
        return BeanUtils.copyList(supplierOrdersDao.findAllByDuibaOrderNum(duibaOrderNum),SupplierOrderDto.class);
    }

    /**
     *
     * @param duibaOrderNum
     * @return
     */
    public SupplierOrderDto findByDuibaOrderNum(String duibaOrderNum){
        return BeanUtils.copy(supplierOrdersDao.findByDuibaOrderNum(duibaOrderNum),SupplierOrderDto.class);
    }

    public int tempDeleteRecord(Long id){
        return supplierOrdersDao.tempDeleteRecord(id);
    }

    public List<SupplierOrderDto>  findAllByOrderId(Long orderId){
        return BeanUtils.copyList(supplierOrdersDao.findAllByOrderId(orderId),SupplierOrderDto.class);
    }

}
