package cn.com.duiba.order.center.biz.service.mainorder.orderapp;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.order.center.biz.dao.BaseOrderTool;
import cn.com.duiba.order.center.biz.dao.orderapp.OrdersAppDao;
import cn.com.duiba.order.center.biz.entity.OrdersEntity;

@Service
public class MirrorOrderSimpleService {

	@Autowired
	private OrdersAppDao ordersAppDao;
	
	
//	public int insert(OrdersEntity order){
//		Long appId = order.getAppId();
//		if(appId == null){
//			return 0;
//		}
//		order.setTableName(getTableName(appId));
//		return ordersAppDao.insert(order);
//	}
    
    //orderNums以逗号隔开
	public List<OrdersEntity> findByOrderNums(List<String> orderNums, Long appId){
		if(appId == null){
			return null;
		}
    	String tableName = getTableName(appId);
    	return ordersAppDao.findByOrderNums(orderNums, appId, tableName);
    }
    
//	public OrdersEntity findByOrderNum(String orderNum, Long appId){
//		if(appId == null){
//			return null;
//		}
//    	String tableName = getTableName(appId);
//    	return ordersAppDao.findByOrderNum(orderNum, appId, tableName);
//    }
	
	private String getTableName(Long appId){
		return "orders_mirror_" + BaseOrderTool.getTableSuffix(appId);
	}
}
