package cn.com.duiba.order.center.biz.service.mainorder.orderconsumer;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.order.center.api.dto.OrdersDto;
import cn.com.duiba.order.center.biz.entity.OrdersEntity;
import cn.com.duiba.order.center.biz.handle.MainOrderSimpleHandle;
import cn.com.duiba.wolf.utils.BeanUtils;

/**
 * Created by yansen on 16/9/22.
 */
@Service
public class OrderSimpleService {
    @Autowired
    private MainOrderSimpleHandle mainOrderSimpleHandle;

    /**
     * 根据订单id和用户id查询订单
     *
     * @param id
     * @param consumerId
     * @return
     */
    public OrdersDto findById(Long id, Long consumerId) {
        return BeanUtils.copy(mainOrderSimpleHandle.findById(id, consumerId), OrdersDto.class);
    }
    
    public List<OrdersDto> findByIds(List<Long> ids, Long consumerId){
    	List<OrdersEntity> list = mainOrderSimpleHandle.findByIds(ids, consumerId);
    	List<OrdersDto> dtos = new ArrayList<>();
		for(OrdersEntity entity : list){
			OrdersDto dto = BeanUtils.copy(entity, OrdersDto.class);
			dtos.add(dto);
		}
    	return dtos;
    }
    
    public List<OrdersDto> findByIdsInSequence(List<Long> ids, String sequence, Long consumerId){
    	List<OrdersEntity> list = mainOrderSimpleHandle.findByIdsInSequence(ids, sequence, consumerId);
    	List<OrdersDto> dtos = new ArrayList<>();
		for(OrdersEntity entity : list){
			OrdersDto dto = BeanUtils.copy(entity, OrdersDto.class);
			dtos.add(dto);
		}
    	return dtos;
    }

    /**
     * 根据订单唯一编号查询订单
     *
     * @param orderNum
     * @return
     */
    public OrdersDto findByOrderNum(String orderNum) {
        return BeanUtils.copy(mainOrderSimpleHandle.findByOrderNum(orderNum), OrdersDto.class);
    }

    /**
     * 通过for update的方式查询订单
     * @param orderId
     * @param consumerId
     * @return
     */
    public OrdersDto select4updatelock(Long orderId, Long consumerId) {
        return BeanUtils.copy(mainOrderSimpleHandle.select4updatelock(orderId,consumerId),OrdersDto.class);
    }

    /**
     * 改用发号器的订单使用查询分库,改造前的查询house库
     * @param id
     * @return
     */
    public OrdersDto findById(Long id){
        return BeanUtils.copy(mainOrderSimpleHandle.findById(id),OrdersDto.class);
    }
}
