package cn.com.duiba.order.center.biz.service.mainorder.orderconsumer;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.order.center.biz.handle.OrdersStatusChangeHandle;
import cn.com.duiba.order.center.biz.service.mainorder.OrderSyncService;

/**
 * Created by yansen on 16/9/22.
 */
@Service
public class OrdersStatusChangeService {
    @Autowired
    private OrdersStatusChangeHandle ordersStatusChangeHandle;

    @Autowired
    private OrderSyncService orderSyncService;

    /**
     *
     * @param orderId
     * @param consumerId
     * @param payStatus
     * @return
     */
    public Integer updatePayOrderStatus(Long orderId, Long consumerId, String payStatus) {
        Integer ret= ordersStatusChangeHandle.updatePayOrderStatus(orderId,consumerId,payStatus);
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    /**
     *
     * @param orderId
     * @param consumerId
     * @return
     */
    public Integer doMakeConsumeSuccess(Long orderId, Long consumerId){
        Integer ret= ordersStatusChangeHandle.doMakeConsumeSuccess(orderId,consumerId);
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    /**
     *
     * @param orderId
     * @param consumerId
     * @param failType
     * @param error4consumer
     * @param error4developer
     * @param error4admin
     * @return
     */
    public Integer doMakeConsumeFail( Long orderId, Long consumerId, Integer failType,String error4consumer,String error4developer, String error4admin){
        Integer ret= ordersStatusChangeHandle.doMakeConsumeFail(orderId,consumerId,failType,error4consumer,error4developer,error4admin);
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    /**
     * 加钱购支付成功 后 更新加钱购支付状态  为  pay_success
     * @param orderId
     * @param consumerId
     * @return
     */
    public Integer doAmbConsumerPayStatusPaySuccess(Long orderId, Long consumerId) {
        Integer ret= ordersStatusChangeHandle.doAmbConsumerPayStatusPaySuccess(orderId,consumerId);
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    /**
     *
     * @param orderId
     * @param consumerId
     * @return
     */
    public Integer doAuditPass(Long orderId, Long consumerId) {
        Integer ret= ordersStatusChangeHandle.doAuditPass(orderId,consumerId);
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    /**
     *
     * @param orderId
     * @param consumerId
     * @param error4consumer
     * @param error4developer
     * @param error4admin
     * @param failType
     * @return
     */
    public Integer doAuditReject(Long orderId, Long consumerId, String error4consumer, String error4developer, String error4admin, Integer failType) {
        Integer ret= ordersStatusChangeHandle.doAuditReject(orderId,consumerId,error4consumer,error4developer,error4admin,failType);
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    /**
     *
     * @param orderId
     * @param consumerId
     * @param payStatus
     * @param duibaPayStatus
     * @param consumerPayStatus
     * @return
     */
    public Integer doMakeSuccess(Long orderId, Long consumerId, String payStatus, String duibaPayStatus, String consumerPayStatus) {
        Integer ret= ordersStatusChangeHandle.doMakeSuccess(orderId,consumerId,payStatus,duibaPayStatus,consumerPayStatus);
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    /**
     *
     * @param orderId
     * @param consumerId
     * @param payStatus
     * @param duibaPayStatus
     * @param consumerPayStatus
     * @param consumerPaybackPrice
     * @return
     */
    public Integer doMakeFail(Long orderId, Long consumerId, String payStatus, String duibaPayStatus, String consumerPayStatus, Long consumerPaybackPrice) {
        Integer ret = ordersStatusChangeHandle.doMakeFail(orderId, consumerId, payStatus, duibaPayStatus, consumerPayStatus, consumerPaybackPrice);
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    /**
     *
     * @param orderId
     * @param consumerId
     * @param duibaPayStatus
     * @return
     */
    public Integer updateDuibaPayOrderStatus(Long orderId, Long consumerId, String duibaPayStatus) {
        Integer ret=ordersStatusChangeHandle.updateDuibaPayOrderStatus(orderId,consumerId,duibaPayStatus);
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    /**
     *
     * @param orderId
     * @param consumerId
     * @param supplierOrderId
     * @param bizParams
     * @param brief
     * @return
     */
    public Integer doUpdateAllowInputUsed(Long orderId, Long consumerId, Long supplierOrderId, String bizParams, String brief) {
        Integer ret = ordersStatusChangeHandle.doUpdateAllowInputUsed(orderId, consumerId, supplierOrderId, bizParams, brief);
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    /**
     *
     * @param orderId
     * @param consumerId
     * @param supplierOrderId
     * @param bizParams
     * @return
     */
    public Integer doUpdateAllowInputUsed4Object(Long orderId, Long consumerId, Long supplierOrderId, String bizParams) {
        Integer ret=ordersStatusChangeHandle.doUpdateAllowInputUsed4Object(orderId,consumerId,supplierOrderId,bizParams);
        orderSyncService.sync(orderId, consumerId);
        return ret;
    }

    /**
     *
     * @param orderId
     * @param consumerId
     * @return
     */
    public Integer doAmbStatusAfterSend(Long orderId, Long consumerId) {
        Integer ret = ordersStatusChangeHandle.doAmbStatusAfterSend(orderId, consumerId);
        return ret;
    }
}
