package cn.com.duiba.order.center.biz.service.message;

import java.nio.charset.Charset;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.SendResult;

import cn.com.duiba.order.center.api.dto.OrderAuditMessageDto;
import cn.com.duiba.order.center.api.dto.OrderCreateContext;
import cn.com.duiba.order.center.api.dto.OrderSyncMessageDto;
import cn.com.duiba.order.center.biz.constant.OnsTopicConstant;

@Service
public class OnsMessageService {

	private static final Logger logger = LoggerFactory.getLogger(OnsMessageService.class);
	
	@Autowired
	private OnsTopicConstant onsTopicConstant;
	
	@Autowired
	private Producer onsProducer;
	
	/**
	 * 创建订单时，发送消息，异步触发订单流程
	 * @param tag
	 * @param orderCreateContext
	 */
	public void sendOrderCreateMsg(String tag, OrderCreateContext orderCreateContext){
		String message = JSONObject.toJSONString(orderCreateContext);
		sendMsg(onsTopicConstant.ordercreate, tag, message);
	}
	
	/**
	 * 发送订单数据同步消息 TODO 该功能需要数据同步系统配合，还未进行匹配
	 * @param orderId
	 * @param consumerId
	 */
//	public void sendOrderSyncMsg(Long orderId, Long consumerId){
//		OrderSyncMessageDto msg = new OrderSyncMessageDto();
//		msg.setOrderId(orderId);
//		msg.setConsumerId(consumerId);
//		String body = JSONObject.toJSONString(msg);
//		sendMsg(onsTopicConstant.dataSync, "", body);
//	}
	
	/**
	 * 发送订单审核消息，异步触发订单流程
	 * @param auditMsg
	 */
	public void sendAuditMsg(OrderAuditMessageDto auditMsg){
		String msg = JSONObject.toJSONString(auditMsg);
		sendMsg(onsTopicConstant.orderaudit, "", msg);
	}
	
	/**
	 * 收发货消息发送，异步触发订单流程
	 * @param tag
	 * @param msg
	 */
	public void sendAfterSendMsg(String tag, String msg){
		sendMsg(onsTopicConstant.aftersend, tag, msg);
	}
	
	/**
	 * 发送消息
	 * @param topic Message Topic
	 * @param tag Message Tag, 标签，对消息进行再归类，比如对于所有的上游兑换消息可以使用同一个topic，通过tag来区分q币、话费等不同子类
//	 * @param key 设置代表消息的业务关键属性，请尽可能全局唯一，以方便您在无法正常收到消息情况下，可通过MQ控制台查询消息并补发,不设置也不会影响消息正常收发
	 * @param message Message Body,任何二进制形式的数据， MQ不做任何干预，需要Producer与Consumer协商好一致的序列化和反序列化方式
	 */
	private void sendMsg(String topic, String tag, String msg){
		Message message = new Message(topic, tag, msg.getBytes(Charset.forName("utf-8")));
		// send同步发送消息，只要不抛异常就是成功,sendAsync是异步发送消息
		SendResult sendResult = null;
		try{
			sendResult = onsProducer.send(message);
		}catch(Exception e){
			logger.error("消息发送失败,messageId="+ sendResult.getMessageId()+"; topic="+ topic + "; tag=" + tag, e);
		}
	}
	
}
