package cn.com.duiba.tuia.activity.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.common.PageDto;
import cn.com.duiba.tuia.activity.center.api.dto.*;
import cn.com.duiba.tuia.activity.center.api.dto.req.ActivityOptionReq;
import cn.com.duiba.tuia.activity.center.api.dto.req.ReqActivityQuery;
import cn.com.duiba.tuia.activity.center.api.dto.req.ReqPageQuery;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.Date;
import java.util.List;
import java.util.Optional;

/**
 * ClassName: RemoteActivityService <br/>
 * Function: 活动服务和活动奖项，皮肤相关服务. <br/>
 * date: 2017年1月12日 下午9:15:42 <br/>
 *
 * @author wubo
 * @version
 * @since JDK 1.7
 */
@AdvancedFeignClient
public interface RemoteActivityService {

    /**
     * getActivity:(查询活动). <br/>
     *
     * @param id the id
     * @return the activity
     * @author wubo
     * @since JDK 1.7
     */
    DubboResult<TuiaActivityDto> getActivity(Long id);

    /**
     * getActivity:(批量查询活动). <br/>
     *
     * @param ids the ids
     * @return the activity list
     * @author wubo
     * @since JDK 1.7
     */
    DubboResult<List<TuiaActivityDto>> getActivityList(List<Long> ids);

    /**
     * 根据活动名称模糊查询
     * where activity_name like '%activiyName%'
     * limit 100
     * @param title 活动名称
     * @return List<Long>
     */
    DubboResult<List<Long>> selectActivityIdsByTitle(String title);

    /**
     * deleteActivity:(删除活动). <br/>
     * 软删
     *
     * @param id the id
     * @return the dubbo result< long>
     * @author wubo
     * @since JDK 1.7
     */
    DubboResult<Long> deleteActivity(Long id);

    /**
     * saveActivity:(根据id更新活动). <br/>
     * 参数传null会在数据库里存null
     *
     * @param dto 活动dto
     * @return long
     * @author wubo
     * @since JDK 1.7
     */
    DubboResult<Long> saveActivity(TuiaActivityDto dto);



    /**
     * saveActivity:(根据id更新活动). <br/>
     * 参数传null不做改动
     *
     * @param dto 活动dto
     */
    Long updateActivity(TuiaActivityDto dto);

    /**
     * selectPageActivity:(分页查询活动). <br/>
     *
     * @param offset the offset
     * @param max the max
     * @param id the id
     * @param title 活动标题 null 不传null的情况下,%title%查询
     * @param type the type
     * @return page
     * @author wubo
     * @since JDK 1.7
     */
    DubboResult<PageDto<TuiaActivityDto>> selectPageActivity(Integer offset, Integer max, Long id, String title,
                                                                    Integer type);

    /**
     * selectActivityOptionByActivityId:(根据活动id查询活动的奖项). <br/>
     *
     * @param activityId 活动id not null
     * @param includeStock 是否包含库存值(库存值需要调库存中心查询，不需要的话就不要查询)
     * @return the dubbo result< list< activity option dto>>
     * @author wubo
     * @since JDK 1.7
     */
    DubboResult<List<ActivityOptionDto>> selectActivityOptionByActivityId(Long activityId, Boolean includeStock);

    /**
     * selectActivityOption:(根据id查询奖项). <br/>
     *
     * @param optionId 奖项id
     * @return the dubbo result< activity option dto>
     * @author wubo
     * @since JDK 1.7
     */
    DubboResult<ActivityOptionDto> selectActivityOption(Long optionId);

    /**
     * saveActivityOption:(保存奖项). <br/>
     * 有id update <br/>
     * 无id insert <br/>
     *
     * @param options 批量保存奖项
     * @return 保存的数量
     * @author wubo
     * @since JDK 1.7
     */
    DubboResult<Integer> saveActivityOption(List<ActivityOptionDto> options);

    /**
     * deleteActivityOption:(删除奖项). <br/>
     *
     * @param optionId 奖项id
     * @return optionId
     * @author wubo
     * @since JDK 1.7
     */
    DubboResult<Integer> deleteActivityOption(Long optionId);

    /**
     * deleteActivityOption:(批量删除奖项). <br/>
     *
     * @param optionIds 奖项ids
     * @return 删除数量
     * @author wubo
     * @since JDK 1.7
     */
    @RequestMapping("deleteActivityOptionList")
    DubboResult<Integer> deleteActivityOption(List<Long> optionIds);

    /**
     * selectSkinTemplateById:(根据id查询皮肤模板数据). <br/>
     *
     * @param id the id
     * @return the dubbo result< skin template data dto>
     * @author wubo
     * @since JDK 1.7
     */
    DubboResult<SkinTemplateDataDto> selectSkinTemplateById(Long id);

    /**
     * selectSkinTemplateByTemplateType:(查询某活动类型所属的皮肤模板). <br/>
     *
     * @param templateType 皮肤模板类型或者活动类型
     * @return dto
     * @author wubo
     * @since JDK 1.7
     */
    DubboResult<List<SkinTemplateDataDto>> selectSkinTemplateByTemplateType(Integer templateType);


    /**
     * selectSkinTemplateByTemplateType:(查询某活动类型所属的皮肤模板未删除). <br/>
     *
     * @param templateType 皮肤模板类型或者活动类型
     * @return dto
     * @author wubo
     * @since JDK 1.7
     */
    List<SkinTemplateDataDto> selectNotDeleteTemplateType(Integer templateType);

    /**
     * selectSkinTemplateBySkinType:(根据模板标识 查询). <br/>
     *
     * @param skinType 模板标识(唯一的存在)
     * @return the dubbo result< skin template data dto>
     * @author wubo
     * @since JDK 1.7
     */
    DubboResult<SkinTemplateDataDto> selectSkinTemplateBySkinType(String skinType);

    /**
     * saveSkinTemplate:(保存皮肤模板). <br/>
     * 有id update <br/>
     * 无id insert <br/>
     *
     * @param dto the dto
     * @return id
     * @author wubo
     * @since JDK 1.7
     */
    DubboResult<Long> saveSkinTemplate(SkinTemplateDataDto dto,String optionUser);

    /**
     * selectSkinTemplateByPage:(分页查询模板). <br/>
     *
     * @param offset the offset
     * @param max the max
     * @return page
     * @author wubo
     * @since JDK 1.7
     */
    DubboResult<PageDto<SkinTemplateDataDto>> selectSkinTemplateByPageNew(Integer templateType, Integer isDeleted
            , List<Integer> activityDefType, Integer offset, Integer max);
    /**
     * selectSkinTemplateByPage:(分页查询模板). <br/>
     *
     * @param offset the offset
     * @param max the max
     * @return page
     * @author wubo
     * @since JDK 1.7
     */
    DubboResult<PageDto<SkinTemplateDataDto>> selectSkinTemplateByPageNewV2(Integer templateType, Integer isDeleted
            , List<Integer> activityDefType, Integer offset, Integer max,String skinName,String skinType);

    DubboResult<PageDto<SkinTemplateDataDto>> selectSkinTemplateByPageNewV3(Integer templateType,
            Integer joinInType,Integer isDeleted, List<Integer> activityDefType, Integer offset,
            Integer max);
    DubboResult<PageDto<SkinTemplateDataDto>> selectSkinTemplateByPage(Integer offset, Integer max);
    DubboResult<PageDto<SkinTemplateDataDto>> selectSkinTemplateByPageV2(Integer offset, Integer max);

    DubboResult<PageDto<SkinTemplateDataDto>> selectSkinTemplateByPageNewV4(Integer templateType,
    Integer joinInType,Integer isDeleted, List<Integer> activityDefType, Integer offset, Integer max,String skinName,String skinType);

    /**
     * selectSkinTemplateByPage:(分页查询未删除模板). <br/>
     *
     * @param offset the offset
     * @param max the max
     * @return page
     * @author wubo
     * @since JDK 1.7
     */
    PageDto<SkinTemplateDataDto> selectNotDeleteSkinTemplateByPage(Integer offset, Integer max);

    /**
     * selectActivitySkinByActivityId:(查询活动皮肤). <br/>
     *
     * @param activityId the activity id
     * @return dto
     * @author wubo
     * @since JDK 1.7
     */
    DubboResult<ActivitySkinDataDto> selectActivitySkinByActivityId(Long activityId);
    /**
     * selectActivitySkinByActivityId:(查询活动皮肤). <br/>
     *
     * @param activityId the activity id
     * @return dto
     * @author wubo
     * @since JDK 1.7
     */
    DubboResult<ActivitySkinDataDto>  selectActivitySkinByActivityIdV2(Long activityId);



    /**
     * selectActivitySkinByActivityId:(查询活动皮肤). <br/>
     *
     * @param  activityIds  活动id列表
     * @return dto
     * @author wubo
     * @since JDK 1.7
     */
    List<ActivitySkinDataDto> selectActivitySkinByActivityIds(List<Long> activityIds);

    /**
     * selectActivitySkinByActivityId:(查询活动皮肤). <br/>
     * 比上面的多一个字段 JoinInType
     * @param  activityIds  活动id列表
     * @return dto
     * @author wubo
     * @since JDK 1.7
     */
    List<ActivitySkinDataDto> selectActivitySkinByActivityIdsV2(List<Long> activityIds);

    /**
     * insertActivitySkin:(添加活动皮肤关系表). <br/>
     *
     * @param dto the dto
     * @return id
     * @author wubo
     * @since JDK 1.7
     */
    DubboResult<Long> insertActivitySkin(ActivitySkinDataDto dto);

    /**
     * updateActivitySkinDataByActivityId:(更新活动皮肤). <br/>
     *
     * @param activityId the activity id
     * @param dataJson the data json
     * @return activityId
     * @author wubo
     * @since JDK 1.7
     */
    DubboResult<Long> updateActivitySkinDataByActivityId(Long activityId, String dataJson);

    /**
     * selectAllActivityType:(查询所有的活动类型). <br/>
     *
     * @return Integer:String 活动类型：活动类型名称
     * @author wubo
     * @since JDK 1.7
     */
    DubboResult<List<ActivityType>> selectAllActivityType();

    /**
     * selectAllActivityTypeByActivityType:(查询所有的活动类型). <br/>
     *
     * @return Integer:String 活动类型：活动类型名称
     * @author wubo
     * @since JDK 1.7
     */
    DubboResult<List<ActivityType>> selectAllActivityTypeByActivityType(String type);


    /**
     * autoSwitchActivityStatus:(更新某时间点的活动状态). <br/>
     * 
     * @param date 自动开启/关闭的时间点（目前只有自动关闭）
     * @param switches true/false:开启/关闭
     * @return 更新的活动id
     */
    DubboResult<List<Long>> autoSwitchActivityStatus(Date date, Boolean switches);

    /**
     * 查询配置了奖品的奖项个数（已删除的奖项不算）
     * 
     * @param prizeId 奖品id
     * @return 个数
     */
    DubboResult<Integer> selectActivityOptionCountByPrizeId(Long prizeId);

    /**
     * selectActivityList:(批量查询活动). <br/>
     * @param ids 活动id
     * @param includeSkinName 是否包含 皮肤，活动类型 名称
     * @return List<TuiaActivityDto>
     */
    DubboResult<List<TuiaActivityDto>> selectActivityList(List<Long> ids, Boolean includeSkinName);

    /**
         * @Description: isRelateActivity 浮标是否关联存在的活动
         *
         * @Param: [buoyId]
         * @Return: cn.com.duiba.wolf.dubbo.DubboResult<java.lang.Boolean>
         * @throws:
         * @author: youhaijun
         * @Date:   2017/6/19
         */
    DubboResult<List<Long>> selectRelateActivityIds(Long buoyId);

    DubboResult<PageDto<TuiaActivityDto>> selectActivityWithAlipay(Integer offset,Integer max,Long activityId,String title);

    /**
     *
     * @param offset offset
     * @param max  max
     * @param activityId activity
     * @param title title
     * @param activityType 活动类型 0：所有，1：普通活动，2：插件活动（与数据库中的activityType 不是同一个数据）
     * @return
     */

    DubboResult<PageDto<ActivityInfo>> selectActivity4Award(Integer offset, Integer max, Long activityId, String title, Integer activityType);

    /**
     * 管理端调用方法，过滤条件 删除
     */
    DubboResult<List<TuiaActivityDto>> selectActivityListForDirectGuidePage(List<Long> ids);


    /**
     * 批量查询奖项
     * @param optionIds 奖项id
     * @param includePrize 是否关联查询奖品信息
     * @return list ActivityOptionDto
     */
    List<ActivityOptionDto> selectOptionsByIds(List<Long> optionIds,Boolean includePrize);

    /**
     * selectPageActivity:(分页查询活动). <br/>
     *
     * @param reqActivityQuery reqActivityQuery
     * @return page
     */
    DubboResult<PageDto<TuiaActivityDto>> selectPageActivitys(ReqActivityQuery reqActivityQuery);


    PageDto<TuiaActivityDto> selectPageActivityStocks(ReqActivityQuery reqActivityQuery);

    Integer selectTopCount();

    /**
     * 查询所有的不能出的活动id，用于活动异常时的强制下线
     * 1.当活动皮肤为不可用时
     * @return 活动id
     */
    DubboResult<List<Long>> findBadActivityIds();


    /**
     * 描述：根据activityId
     * 查询奖品项
     * @param
     * @return
     * @author weny.cai
     * @date 2018/8/3 14:16
     */
    List<ActivityOptionDto> selectByActivityId(Long activityId, Integer activityCategory) throws BizException;


    /**
     * 获取全部活动id   预览链接截图用
     * @return
     */
    List<Long> selectActivityIds(ReqPageQuery reqPageQuery);


    /**
     * 批量更新
     * @return
     */
    int updateBatch(List<TuiaActivityDto> list);


    boolean submitAudit(Long managerId,Long activityId);


    /**
     * 获取预览链接为空的活动id
     * @return
     */
    List<Long> selectActivityIdsByPreviewUrl(ReqPageQuery reqPageQuery);




    /**
     * selectActivityOption:(根据活动id查询活动的奖项). <br/>
     *
     * @param req
     * @return the dubbo result< list< activity option dto>>
     * @author wubo
     * @since JDK 1.7
     */
    List<ActivityOptionDto> selectByActAndUserType(ActivityOptionReq req);

    boolean saveSkinLayer(List<SkinLayerDto> skinLayerDtoList, String skinType);

    /**
     * 获取下拉框活动
     * @param ids
     * @param name
     * @return
     */
    List<ActivityIdAndNameDto> getActivityByIdsOrName(List<Long> ids ,String name);

    /**
     * @Author zhangliwei
     * @Description  根据皮肤类型和版本号查询历史记录详情
     * @Date 15:16 2019-08-15
     * @Param [skinType, version]
     * @return cn.com.duiba.tuia.media.manager.model.rsp.SkinTemplateDataRsp
     **/
    SkinTemplateDataDto getHistorySkinDetail(String skinType, Integer version);

    /**
     * @Author zhangliwei
     * @Description  根据皮肤模板唯一标识和版本号回滚模板
     * @Date 15:30 2019-08-15
     * @Param [reqRollBackSkin]
     * @return java.lang.Boolean
     **/
    Boolean rollBackSkin(String skinType,Integer version,String optionUser);


    /**
     * @Author zhangliwei
     * @Description  根据skinType查询当前皮肤模板的历史版本list
     * @Date 16:47 2019-08-15
     * @Param [skinType]
     * @return java.util.List<cn.com.duiba.tuia.activity.center.api.dto.HistoryVersionDto>
     **/
    List<HistoryVersionDto> getSkinHistoryList(String skinType);

    /**
     * 活动挑选库：记录收藏活动
     * @param activityId
     * @param userId
     * @return
     */
    boolean recordFavoriteActivity(Long activityId, Long userId);

    /**
     * 获取活动策划人列表
     * @return 活动策划人列表
     */
    List<String> listActivityPlanner();

    /**
     * 获取活动皮肤类型列表
     * @param activityIds 活动ID列表
     * @return 活动皮肤类型列表
     */
    List<ActivitySkinDataDto> listActivitySkinDataDto(List<Long> activityIds);

    /**
     * 获取活动报警人
     * @param activityId
     * @return
     */
    ActivityOptionNoticeDto selectNoticeByActId(Long activityId);

    /**
     * 获取根据id活动创新标记是否存在
     * @param ids
     * @return
     */
    Integer getActivityTag(List<Long> ids);
}
