package cn.com.duiba.tuia.activity.center.api.constant.adx;

import org.apache.commons.lang.StringUtils;
import java.util.Objects;
import java.util.stream.Stream;

/**
 * adx平台类型
 *
 * @author weny.cai
 * @date 2019/1/3 15:46
 **/
public enum AdxTypeEnum {

    /** 猎豹 ADX */
    LIEBAO(1, "猎豹", false, 1, false),

    /** 搜狗 ADX */
    SOUGOU(2, "搜狗", false, 1, false),

    /** 墨迹天气 ADX */
    MOJI(3, "墨迹天气", false, 1, false),

    /** 暴风影音 ADX */
    BAOFENG(4, "暴风影音", false, 2, false),

    /** 百度视频 ADX */
    BAIDU(5, "百度视频", true, 3, false),

    /** 小米 ADX */
    XIAOMI(6, "小米", false, 2, false),

    /** 掌阅 ADX */
    ZHANG_YUE(7, "掌阅", true, 2, false),

    /** 2345 ADX */
    NAVIGATION(8, "2345", true, 3, false),

    /** 连尚 ADX */
    LIAN_SHANG(9, "连尚", false, 2, false),

    /** 小恩爱 ADX */
    XIAO_EN_AI(10, "小恩爱", true, 2, false),

    /** OPPO ADX */
    OPPO(11, "OPPO", true, 2, false),

    /** 爱奇艺 ADX */
    I_QI_YI(12, "爱奇艺", true, 2, false),


    /** MEIZU ADX */
    MEIZU(13, "魅族", true, 2, false),

    /** TEST ADX */
    Test(14, "临时测试组", true, 2, true),

    /** DEV ADX */
    Dev(15, "临时开发组", true, 2, true);



    private Integer type;

    private String name;

    /** 是否需要审核 */
    private Boolean needAudit;
    /**
     * 广告类型存储方式 1-posId 2-spec_code 3-其他
     */
    private Integer storeType;

    /** 是否走新的ADX架构标识符 **/
    private boolean isUpgrade;

    AdxTypeEnum(Integer type, String name, Boolean needAudit, Integer storeType, boolean isUpgrade) {
        this.type = type;
        this.name = name;
        this.needAudit = needAudit;
        this.storeType = storeType;
        this.isUpgrade = isUpgrade;
    }

    public Integer getStoreType() {
        return storeType;
    }

    public void setStoreType(Integer storeType) {
        this.storeType = storeType;
    }

    public Integer getType() {
        return type;
    }

    public String getName() {
        return name;
    }

    public Boolean getNeedAudit() {
        return needAudit;
    }

    public boolean isUpgrade() {
        return isUpgrade;
    }

    public boolean sameAdxType(Integer type) {
        return !Objects.isNull(type) && Objects.equals(this.type, type);
    }

    public static AdxTypeEnum getByType(Integer type) {
        return Objects.isNull(type)
                ? null
                : Stream.of(AdxTypeEnum.values())
                .filter(item -> Objects.equals(item.getType(), type))
                .findFirst().orElse(null);
    }

    /**
     * 判断当前传入的adx类型是否需要审核
     *
     * @param adxType
     * @return
     */
    public static Boolean needAudit(Integer adxType) {
        for (AdxTypeEnum adxTypeEnum : AdxTypeEnum.values()) {
            if (adxType.equals(adxTypeEnum.getType())) {
                return adxTypeEnum.getNeedAudit();
            }
        }
        return false;
    }

    /**
     * 判断所有adx平台类型是否包含传入的adxType
     *
     * @param adxType
     * @return
     */
    public static Boolean contains(Integer adxType) {
        for (AdxTypeEnum adxTypeEnum : AdxTypeEnum.values()) {
            if (adxType == adxTypeEnum.getType()) {
                return true;
            }
        }
        return false;
    }

    /**
     * 根据type获取平台类型
     *
     * @param type
     * @return
     */
    public static AdxTypeEnum getEnumByType(Integer type) {
        for (AdxTypeEnum typeEnum : AdxTypeEnum.values()) {
            if (type == typeEnum.getType()) {
                return typeEnum;
            }
        }
        return null;
    }

    /**
     * 根据adxName获取adxType
     * @param adxName 名称
     * @return 编码值
     */
    public static Integer getAdxType(String adxName){
        if(StringUtils.isBlank(adxName)){return 0;}
        for(AdxTypeEnum adxTypeEnum : AdxTypeEnum.values()){
            if(adxTypeEnum.getName().equals(adxName)){
                return adxTypeEnum.getType();
            }
        }
        return 0;
    }
}
