package cn.com.duiba.tuia.activity.center.api.remoteservice.adx;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.dto.adx.AdvertisingSpaceTypeDto;
import cn.com.duiba.tuia.activity.center.api.dto.adx.AdvertisingSpaceTypesDto;
import cn.com.duiba.tuia.activity.center.api.dto.adx.AdvertisingSpaceTypeInsertDto;
import cn.com.duiba.tuia.activity.center.api.dto.adx.AdvertisingSpaceTypeUpdateDto;

import java.util.List;

/**
 * @author shenjiaqing
 * @description 广告位类型功能开发
 * @data 2019/11/18
 */
@AdvancedFeignClient
public interface RemoteAdvertisingSpaceTypeService {

    /**
     * 功能描述 根据Adx平台类型获取广告位类型列表
     * @author shenjiaqing
     * @date 13:39 2019/11/19
     * @param [adxType]
     * @return java.util.List<cn.com.duiba.tuia.activity.center.api.dto.adx.AdvertisingSpaceTypesDto>
     **/
    List<AdvertisingSpaceTypesDto> getAllByAdxType(Integer adxType);

    /**
     * 功能描述 检查广告位类型名称的唯一性
     * @author shenjiaqing
     * @date 13:38 2019/11/19
     * @param [typeName]
     * @return java.lang.Integer
     **/
    boolean typeNameIsExists(String typeName, Long id, Integer adxType);

    /**
     * 功能描述 检查Adx对应广告位类型Id的唯一性
     * @author shenjiaqing
     * @date 17:33 2019/11/20
     * @param [templateId]
     * @return java.lang.Integer
     **/
    boolean templateIdIsExists(String templateId, Long id);

    /**
     * 功能描述 添加广告位类型
     * @author shenjiaqing
     * @date 13:39 2019/11/19
     * @param [dto]
     * @return java.lang.Integer
     **/
    boolean insert(AdvertisingSpaceTypeInsertDto dto);

    /**
     * 功能描述 编辑广告位类型
     * @author shenjiaqing
     * @date 13:39 2019/11/19
     * @param [dto]
     * @return java.lang.Integer
     **/
    boolean update(AdvertisingSpaceTypeUpdateDto dto);

    /**
     * 功能描述 根据广告位类型ID获取广告位详情
     * @author shenjiaqing
     * @date 13:39 2019/11/19
     * @param [id]
     * @return cn.com.duiba.tuia.activity.center.api.dto.adx.AdvertisingSpaceTypeDto
     **/
    AdvertisingSpaceTypeDto getAdSpaceTypeById(Long id);

    /**
     * 功能描述 删除广告位类型
     * @author shenjiaqing
     * @date 13:44 2019/11/19
     * @param [id]
     * @return java.lang.Integer
     **/
    boolean delete(Long id, boolean isDeleteStyle);

    /**
     * 功能描述 根据广告位类型ID获取广告位ID
     * @author shenjiaqing
     * @date 14:36 2019/11/19
     * @param [id]
     * @return java.lang.String
     **/
    String getAdPositionIdByAdTypeId(Long id);

    /**
     * 功能描述 根据adxType查询广告位类型
     * @author shenjiaqing
     * @date 9:46 2019/11/21
     * @param [adxType]
     * @return java.util.List<cn.com.duiba.tuia.activity.center.api.dto.adx.AdvertisingSpaceTypesDto>
     **/
    List<AdvertisingSpaceTypesDto> getTypeNameByAdxType(Integer adxType);

    /**
     * 功能描述 查看此广告位是否存在
     * @author shenjiaqing
     * @date 10:29 2019/11/25
     * @param [id]
     * @return boolean
     **/
    boolean adTypeIsExists(Long id);


}
