package cn.com.duiba.tuia.activity.center.api.constant;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public enum OptionUserType {

    DEFAULT(0,"默认/全部"),
    NEW_USER(1,"新用户"),
    OLD_USER(2,"老用户"),
    FIRST_USER(3,"一类用户"),
    SECOND_USER(4,"二类用户"),
    ;


    private Integer code;

    private String desc;


    OptionUserType(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }


    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }


    public static String getDescByCode(Integer code){
        Optional<OptionUserType> optionUserType = Arrays.asList(OptionUserType.values()).stream().filter(e-> Objects.equals(code,e.getCode())).findFirst();
       return optionUserType.isPresent() ? optionUserType.get().getDesc() : "";
    }
}
