package cn.com.duiba.tuia.activity.center.api.dto.inter;

import cn.com.duiba.tuia.activity.center.api.common.BaseDto;
import cn.com.duiba.tuia.activity.center.api.constant.EncryptType;

/**
 * ClassName: InterfaceHttpEncryptDto <br/>
 * Function: http加密参数Dto. <br/>
 * Reason: . <br/>
 * date: 2017年4月14日 下午5:39:23 <br/>
 *
 * @author wubo
 * @version
 * @since JDK 1.7
 */
public class InterfaceHttpEncryptDto extends BaseDto {

    private static final long serialVersionUID = 1L;

    private Long              id;

    private EncryptType       type;

    private String            interfaceCode;

    private String            encryptName;

    private String            encryptKey;

    private String            reqIds;

    /**
     * Creates a new instance of InterfaceHttpEncryptDto.
     */
    public InterfaceHttpEncryptDto() {
        super();
    }

    /**
     * Creates a new instance of InterfaceHttpEncryptDto.
     *
     * @param id
     * @param type
     * @param interfaceCode
     * @param encryptName
     * @param encryptKey
     * @param reqIds
     */

    public InterfaceHttpEncryptDto(Long id, EncryptType type, String interfaceCode, String encryptName,
                                   String encryptKey, String reqIds) {
        super();
        this.id = id;
        this.type = type;
        this.interfaceCode = interfaceCode;
        this.encryptName = encryptName;
        this.encryptKey = encryptKey;
        this.reqIds = reqIds;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public EncryptType getType() {
        return type;
    }

    public void setType(EncryptType type) {
        this.type = type;
    }

    public String getInterfaceCode() {
        return interfaceCode;
    }

    public void setInterfaceCode(String interfaceCode) {
        this.interfaceCode = interfaceCode;
    }

    public String getEncryptName() {
        return encryptName;
    }

    public void setEncryptName(String encryptName) {
        this.encryptName = encryptName;
    }

    public String getEncryptKey() {
        return encryptKey;
    }

    public void setEncryptKey(String encryptKey) {
        this.encryptKey = encryptKey;
    }

    public String getReqIds() {
        return reqIds;
    }

    public void setReqIds(String reqIds) {
        this.reqIds = reqIds;
    }

}
