package cn.com.duiba.tuia.activity.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.common.PageDto;
import cn.com.duiba.tuia.activity.center.api.dto.FundChangeDto;
import cn.com.duiba.tuia.activity.center.api.dto.req.FundChangeQueryReq;

@AdvancedFeignClient
public interface RemoteFundChangeService {

    /**
     * 查询流水
     *
     * @param req
     * @return
     */
    PageDto<FundChangeDto> selectByReqQuery(FundChangeQueryReq req);

    /**
     *
     * @param fundBodyId 游戏或者游戏大厅ID
     * @param fundBodyType 0 游戏大厅 1 游戏
     * @return 当前流通货币(单位是金币)
     */
    Long getFlowAmount(Long fundBodyId,Integer fundBodyType);


    /**
     *
     * @param fundBodyId 游戏或者游戏大厅ID
     * @param fundBodyType 0 游戏大厅 1 游戏
     * @param changeAmount 修改金额
     * @param changeType 0初始化预算 1增加预算 2减少预算 3 兑换
     * @param msg 备注信息，如果是兑吧兑换商品则为订单号
     * @param operator 操作人姓名
     * @return 是否成功
     */
    Boolean updateFlowAmount(Long fundBodyId, Integer fundBodyType, Long changeAmount, Integer changeType,
                             String msg,String operator);
}
