package cn.com.duiba.tuia.activity.center.api.constant.adx;

import com.google.common.collect.Sets;
import org.apache.commons.lang3.StringUtils;

import java.util.Set;
import java.util.stream.Stream;

/**
 * 暴风adx广告位大小规格枚举
 * @Author chensong
 * @Create 2019-03-07
 */
public enum BaoFengSpecEnum {

    BAOFENG001("BAOFENG001", Sets.newHashSet("15746479", "15746486"), "通用信息流-小图-Android", 1, 230, 130),

    BAOFENG002("BAOFENG002", Sets.newHashSet("15746505", "15746509"), "通用信息流-大图，组图-Android", 3, 480, 270),

    BAOFENG003("BAOFENG003", Sets.newHashSet("15746480", "15746485"), "通用信息流-小图-iOS", 1, 230, 130),

    BAOFENG004("BAOFENG004", Sets.newHashSet("15746506", "15746510"), "通用信息流-大图，组图-iOS", 3, 480, 270),

    BAOFENG005("BAOFENG005", Sets.newHashSet("15746498"), "开屏-Android", 1, 750, 1120),

    BAOFENG006("BAOFENG006", Sets.newHashSet("15746496"), "开屏-iPhone", 1, 750, 1167),

    BAOFENG007("BAOFENG007", Sets.newHashSet("15746497"), "开屏-iPad", 1, 1024, 768),

    BAOFENG008("BAOFENG008", Sets.newHashSet("15746489"), "中播-Android", 1, 228, 128),

    BAOFENG009("BAOFENG009", Sets.newHashSet("15746487"), "中播-iPhone", 1, 228, 128),

    BAOFENG010("BAOFENG010", Sets.newHashSet("15746488"), "中播-iPad", 1, 422, 238),

    BAOFENG011("BAOFENG011", Sets.newHashSet("15746527"), "把手-Android", 1, 100, 100),

    BAOFENG012("BAOFENG012", Sets.newHashSet("15746526"), "把手-iPhone", 1, 100, 100),

    BAOFENG013("BAOFENG013", Sets.newHashSet("15746525"), "详情页顶部栏-Android", 1, 710, 120),

    BAOFENG014("BAOFENG014", Sets.newHashSet("15746524"), "详情页顶部栏-iPhone", 1, 710, 120),

    BAOFENG015("BAOFENG015", Sets.newHashSet("15746495"), "角标-Android", 1, 153, 102),

    BAOFENG016("BAOFENG016", Sets.newHashSet("15746493"), "角标-iPhone", 1, 153, 102),

    BAOFENG017("BAOFENG017", Sets.newHashSet("15746494"), "角标-iPad", 1, 246, 164);

    /** 规格编码 */
    private String specCode;

    /** 媒体广告位id */
    private Set<String> slotIds;

    /** 描述 */
    private String desc;

    /** 最多图片数量 -1表示不限*/
    private int maxPicSize;

    /** 图片宽度 */
    private int picWidth;

    /** 图片高度 */
    private int picHeight;

    private BaoFengSpecEnum(String specCode, Set<String> slotIds, String desc, int maxPicSize, int picWidth, int picHeight) {
        this.specCode = specCode;
        this.slotIds = slotIds;
        this.desc = desc;
        this.maxPicSize = maxPicSize;
        this.picWidth = picWidth;
        this.picHeight = picHeight;
    }

    public String getSpecCode() {
        return specCode;
    }

    public Set<String> getSlotIds() {
        return slotIds;
    }

    public String getDesc() {
        return desc;
    }

    public int getMaxPicSize() {
        return maxPicSize;
    }

    public int getPicWidth() {
        return picWidth;
    }

    public int getPicHeight() {
        return picHeight;
    }

    /**
     * 根据规格编码获取
     * @param code
     * @return
     */
    public static BaoFengSpecEnum getByCode(String code) {
        return StringUtils.isBlank(code) ? null
                : Stream.of(BaoFengSpecEnum.values())
                        .filter(item -> StringUtils.equals(item.getSpecCode(), code))
                        .findFirst().orElse(null);
    }

}
