package cn.com.duiba.tuia.activity.center.api.constant.adx;

import cn.com.duiba.tuia.activity.center.api.bean.AdStyle;
import cn.com.duiba.tuia.activity.center.api.bean.AdType;
import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.List;

/**
 * 掌阅adx广告类型和规格
 * @Author chensong
 * @Create 2019-03-07
 */
@Getter
@AllArgsConstructor
public enum ZhangYueSpecEnum {

    ZHANG_YUE_001(7,"ZHANGYUE001",1,"横幅",15, "","一图一文","{\"height\":608,\"size\":150,\"width\":1080}"),
    ZHANG_YUE_002(7,"ZHANGYUE002",2,"原生信息流",16,"1-2","原生信息流贴片","{\"descCount\":18,\"height\":720,\"size\":150,\"titleCount\":13,\"width\":1280}");

    private Integer adxType;
    /**
     * dsp侧广告类型名称
     */
    private String name;
    /**
     * 广告类型
     */
    private Integer typeKey;
    /**
     * 广告类型描述
     */
    private String typeValue;
    /**
     * 规格样式
     */
    private Integer styleStandard;
    /**
     * 广告样式
     */
    private String template;
    /**
     * 广告样式描述
     */
    private String templateDescription;
    /**
     * 素材要求
     */
    private String demand;


    public static List<AdType> generate(){
        List<AdType> adTypeList = Lists.newArrayList();
        for(ZhangYueSpecEnum zhangYueSpecEnum : ZhangYueSpecEnum.values()){
            adTypeList.add(AdType.builder().styleList(generateAdStyle(zhangYueSpecEnum.getName())).id(zhangYueSpecEnum.getName()).value(zhangYueSpecEnum.getTypeValue()).build());
        }
        return adTypeList;
    }

    public static List<AdStyle> generateAdStyle(String id){
        List<AdStyle> adStyleList = Lists.newArrayList();
        for(ZhangYueSpecEnum zhangYueSpecEnum : ZhangYueSpecEnum.values()){
            if(id.equals(zhangYueSpecEnum.getName())){
                adStyleList.add(AdStyle.builder().styleStandard(zhangYueSpecEnum.getStyleStandard()).description(zhangYueSpecEnum.getTemplateDescription()).build());
            }
        }
        return adStyleList;
    }

    public static String getTemplateIdByStyleStandard(Integer styleStandard){
        for(ZhangYueSpecEnum zhangYueSpecEnum : ZhangYueSpecEnum.values()){
            if(zhangYueSpecEnum.getStyleStandard().equals(styleStandard)){
                return zhangYueSpecEnum.getTemplate();
            }
        }
        return "";
    }

    public static String getDemand(Integer adxType, Integer styleStandard){
        for(ZhangYueSpecEnum zhangYueSpecEnum : ZhangYueSpecEnum.values()){
            if (adxType!=null&& styleStandard!=null ){
                if(adxType.equals(zhangYueSpecEnum.getAdxType()) && styleStandard.equals(zhangYueSpecEnum.getStyleStandard())){
                    return zhangYueSpecEnum.getDemand();
                }
            }
        }
        return "";
    }



}
