/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.activity.center.api.constant.adx;

import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;

public enum AdxTypeEnum {
    LIEBAO(1, "\u730e\u8c79", false, 1, "55287", "3", false),
    SOUGOU(2, "\u641c\u72d7", false, 1, "56100", "10", false),
    MOJI(3, "\u58a8\u8ff9\u5929\u6c14", false, 1, "57045", "11", false),
    BAOFENG(4, "\u66b4\u98ce\u5f71\u97f3", false, 2, "58196", "18", false),
    BAIDU(5, "\u767e\u5ea6\u89c6\u9891", true, 3, "58834", "17", false),
    XIAOMI(6, "\u5c0f\u7c73", false, 2, "58972", "21", false),
    ZHANG_YUE(7, "\u638c\u9605", true, 2, "61112", "31", false),
    NAVIGATION(8, "2345", true, 3, "63596", "42", false),
    LIAN_SHANG(9, "\u8fde\u5c1a", false, 2, "64738", "59", false),
    XIAO_EN_AI(10, "\u5c0f\u6069\u7231", true, 2, "63597", "71", false),
    OPPO(11, "OPPO", true, 2, "66506", "84", false),
    I_QI_YI(12, "\u7231\u5947\u827a", true, 2, "69636", "96", true),
    MEIZU(13, "\u9b45\u65cf", true, 2, "68016", "94", false),
    MONGO_TV(14, "\u8292\u679cTV", true, 3, "69972", "124", true),
    APUS(15, "APUS", true, 2, "69989", "115", false),
    MEI_SHU(16, "\u7f8e\u6570", true, 2, "69822", "118", false),
    LENOVO(17, "\u8054\u60f3", true, 3, "70379", "125", true),
    MOMO(18, "\u964c\u964c", true, 3, "70391", "119", true);

    private Integer type;
    private String name;
    private Boolean needAudit;
    private Integer storeType;
    private boolean isUpgrade;
    private String mediaId;
    private String groupId;

    private AdxTypeEnum(Integer type, String name, Boolean needAudit, Integer storeType, String mediaId, String groupId, boolean isUpgrade) {
        this.type = type;
        this.name = name;
        this.needAudit = needAudit;
        this.storeType = storeType;
        this.mediaId = mediaId;
        this.groupId = groupId;
        this.isUpgrade = isUpgrade;
    }

    public Integer getStoreType() {
        return this.storeType;
    }

    public void setStoreType(Integer storeType) {
        this.storeType = storeType;
    }

    public Integer getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getNeedAudit() {
        return this.needAudit;
    }

    public String getMediaId() {
        return this.mediaId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public boolean isUpgrade() {
        return this.isUpgrade;
    }

    public boolean sameAdxType(Integer type) {
        return !Objects.isNull(type) && Objects.equals(this.type, type);
    }

    public static AdxTypeEnum getByType(Integer type) {
        return Objects.isNull(type) ? null : (AdxTypeEnum)Stream.of(AdxTypeEnum.values()).filter(item -> Objects.equals(item.getType(), type)).findFirst().orElse(null);
    }

    public static Boolean needAudit(Integer adxType) {
        for (AdxTypeEnum adxTypeEnum : AdxTypeEnum.values()) {
            if (!adxType.equals(adxTypeEnum.getType())) continue;
            return adxTypeEnum.getNeedAudit();
        }
        return false;
    }

    public static Boolean contains(Integer adxType) {
        for (AdxTypeEnum adxTypeEnum : AdxTypeEnum.values()) {
            if (adxType != adxTypeEnum.getType()) continue;
            return true;
        }
        return false;
    }

    public static AdxTypeEnum getEnumByType(Integer type) {
        for (AdxTypeEnum typeEnum : AdxTypeEnum.values()) {
            if (type != typeEnum.getType()) continue;
            return typeEnum;
        }
        return null;
    }

    public static Integer getAdxType(String adxName) {
        if (StringUtils.isBlank((String)adxName)) {
            return 0;
        }
        for (AdxTypeEnum adxTypeEnum : AdxTypeEnum.values()) {
            if (!adxTypeEnum.getName().equals(adxName)) continue;
            return adxTypeEnum.getType();
        }
        return 0;
    }
}

