/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.activity.center.api.constant.adx;

import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;

public enum AdxTypeEnum {
    LIEBAO(1, "\u730e\u8c79", false, 1, "55287", "3", false, false),
    SOUGOU(2, "\u641c\u72d7", false, 1, "56100", "10", false, false),
    MOJI(3, "\u58a8\u8ff9\u5929\u6c14", false, 1, "57045", "11", false, false),
    BAOFENG(4, "\u66b4\u98ce\u5f71\u97f3", false, 2, "58196", "18", false, false),
    BAIDU(5, "\u767e\u5ea6\u89c6\u9891", true, 3, "58834", "17", false, false),
    XIAOMI(6, "\u5c0f\u7c73", false, 2, "58972", "21", false, false),
    ZHANG_YUE(7, "\u638c\u9605", true, 2, "61112", "31", false, false),
    NAVIGATION(8, "2345", true, 3, "63596", "42", false, false),
    LIAN_SHANG(9, "\u8fde\u5c1a", false, 2, "64738", "59", false, false),
    XIAO_EN_AI(10, "\u5c0f\u6069\u7231", true, 2, "63597", "71", false, false),
    OPPO(11, "OPPO", true, 2, "66506", "84", false, false),
    I_QI_YI(12, "\u7231\u5947\u827a", true, 2, "69636", "96", true, true),
    MEIZU(13, "\u9b45\u65cf", true, 2, "68016", "94", false, false),
    MONGO_TV(14, "\u8292\u679cTV", true, 3, "69972", "124", true, false),
    APUS(15, "APUS", true, 2, "69989", "115", false, false),
    MEI_SHU(16, "\u7f8e\u6570", true, 2, "69822", "118", false, false),
    LENOVO(17, "\u8054\u60f3", true, 3, "70379", "125", true, false),
    MOMO(18, "\u964c\u964c", true, 3, "70391", "119", true, false),
    BAIDU_ALLIANCE(19, "\u767e\u5ea6\u8054\u76df", false, 3, "71092", "129", true, false),
    IWANVI(20, "\u4e2d\u6587\u4e07\u7ef4", false, 3, "71189", "130", true, false),
    MOMO_OPEN_SCREEN(21, "\u964c\u964c\u5f00\u5c4f", false, 3, "71941", "134", true, false);

    private Integer type;
    private String name;
    private Boolean needAudit;
    private Integer storeType;
    private boolean isUpgrade;
    private String mediaId;
    private String groupId;
    private Boolean advertiserNeedAudit;

    private AdxTypeEnum(Integer type, String name, Boolean needAudit, Integer storeType, String mediaId, String groupId, boolean isUpgrade, Boolean advertiserNeedAudit) {
        this.type = type;
        this.name = name;
        this.needAudit = needAudit;
        this.storeType = storeType;
        this.mediaId = mediaId;
        this.groupId = groupId;
        this.isUpgrade = isUpgrade;
        this.advertiserNeedAudit = advertiserNeedAudit;
    }

    public Integer getStoreType() {
        return this.storeType;
    }

    public void setStoreType(Integer storeType) {
        this.storeType = storeType;
    }

    public Integer getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getNeedAudit() {
        return this.needAudit;
    }

    public String getMediaId() {
        return this.mediaId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public boolean isUpgrade() {
        return this.isUpgrade;
    }

    public Boolean getAdvertiserNeedAudit() {
        return this.advertiserNeedAudit;
    }

    public boolean sameAdxType(Integer type) {
        return !Objects.isNull(type) && Objects.equals(this.type, type);
    }

    public static AdxTypeEnum getByType(Integer type) {
        return Objects.isNull(type) ? null : (AdxTypeEnum)Stream.of(AdxTypeEnum.values()).filter(item -> Objects.equals(item.getType(), type)).findFirst().orElse(null);
    }

    public static Boolean needAudit(Integer adxType) {
        for (AdxTypeEnum adxTypeEnum : AdxTypeEnum.values()) {
            if (!adxType.equals(adxTypeEnum.getType())) continue;
            return adxTypeEnum.getNeedAudit();
        }
        return false;
    }

    public static Boolean contains(Integer adxType) {
        for (AdxTypeEnum adxTypeEnum : AdxTypeEnum.values()) {
            if (adxType != adxTypeEnum.getType()) continue;
            return true;
        }
        return false;
    }

    public static AdxTypeEnum getEnumByType(Integer type) {
        for (AdxTypeEnum typeEnum : AdxTypeEnum.values()) {
            if (type != typeEnum.getType()) continue;
            return typeEnum;
        }
        return null;
    }

    public static Integer getAdxType(String adxName) {
        if (StringUtils.isBlank((String)adxName)) {
            return 0;
        }
        for (AdxTypeEnum adxTypeEnum : AdxTypeEnum.values()) {
            if (!adxTypeEnum.getName().equals(adxName)) continue;
            return adxTypeEnum.getType();
        }
        return 0;
    }

    public static Boolean advertiserNeedAudit(Integer adxType) {
        for (AdxTypeEnum adxTypeEnum : AdxTypeEnum.values()) {
            if (!adxType.equals(adxTypeEnum.getType())) continue;
            return adxTypeEnum.getAdvertiserNeedAudit();
        }
        return false;
    }
}

