package cn.com.duiba.tuia.activity.center.api.dto.adx;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author guopengfei@duiba.com.cn
 * @version 1.0
 * @date 2020-05-07
 */
@Data
public class PmpDealOrderDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 交易平台类型
     */
    private Integer adxType;

    /**
     * 交易平台排期单ID
     */
    private String dealId;

    /**
     * 交易平台排期单名称
     */
    private String dealName;

    /**
     * 排期单单价，单位:分
     */
    private Long price;

    /**
     * 排期单预算，单位:分
     */
    private Long budget;

    /**
     * 排期单退量限制比例
     */
    private Integer returnLimitType;

    /**
     * 排期单退量比，0代表PD
     */
    private Integer returnRate;

    /**
     * 终端类型 0-Mobile 1-Web 2-Pad
     */
    private Integer termType;

    /**
     * 投放周期 0-不限;1-指定
     */
    private Integer periodType;

    /**
     * 投放时段(小时维度) 0-不限;1-指定
     */
    private Integer hourType;

    /**
     * 广告主类型 0-互动;1-直投
     */
    private Integer advertiserType;

    /**
     * 交易平台广告位ID
     */
    private String posId;

    /**
     * 状态 （0：开，1：关）默认为0
     */
    private Integer status;

    /**
     * 交易周期 示例：['2020-01-01~2020-01-02','2020-01-04~2020-01-05']
     */
    private List<DealOrderPeriodDTO> dealOrderPeriodDTOList;

    /**
     * 每日交易单排期
     * [{
     * "weekDay":"1", // 周一
     * "hour":"111111111(24个)"
     * },{
     * "weekDay":"2", // 周二
     * "hour":"111111111(24个)"
     * },{
     * "weekDay":"3",
     * "hour":"111111111(24个)"
     * },{
     * "weekDay":"4",
     * "hour":"111111111(24个)"
     * },{
     * "weekDay":"5",
     * "hour":"111111111(24个)"
     * },{
     * "weekDay":"6",
     * "hour":"111111111(24个)"
     * },{
     * "weekDay":"7",
     * "hour":"111111111(24个)"
     * }]
     */
    private List<DealOrderWeekHourDTO> dealOrderWeekHourDTOList;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 周期转字符
     *
     * @return
     */
    public List<String> periodListToString() {
        if (dealOrderPeriodDTOList == null) {
            return Lists.newArrayList();
        }
        return dealOrderPeriodDTOList.stream().map(e -> e.getBgnDate().toString() + "~" + e.getEndDate().toString()).collect(Collectors.toList());
    }

    /**
     * 小时转list字符
     *
     * @return
     */
    public List<Map<String, String>> hourListToString() {
        if (dealOrderWeekHourDTOList == null) {
            return Lists.newArrayList();
        }
        return dealOrderWeekHourDTOList.stream().map(e -> {
            Map<String, String> map = Maps.newHashMap();
            map.put("weekDay", e.getWeekDay().toString());
            map.put("hour", e.getPeriodHour());
            return map;
        }).collect(Collectors.toList());
    }

}