package cn.com.duiba.tuia.activity.center.api.dto.req;

import lombok.Data;

import java.util.List;

/**
 * pmp分页
 *
 * @author guopengfei@duoba.com.cn
 * @date 2018/12/3 14:51
 **/
@Data
public class PmpDealOrderPageReq extends ReqPageQuery {

    /**
     * 主键
     */
    private Long id;

    /**
     * 主键列表(主要用于日期反查)
     */
    private List<Long> idList;

    /**
     * 交易平台类型
     */
    private Integer adxType;

    /**
     * 交易平台排期单ID
     */
    private String dealId;

    /**
     * 交易平台排期单名称
     */
    private String dealName;

    /**
     * 排期单退量限制比例 0-PD 1-PDB
     */
    private Integer returnLimitType;

    /**
     * 终端类型 0-Mobile 1-Web 2-Pad
     */
    private Integer termType = 1;

    /**
     * 投放周期 0-不限;1-指定
     */
    private Integer periodType;

    /**
     * 投放时段(小时维度) 0-不限;1-指定
     */
    private Integer hourType;

    /**
     * 广告主类型 0-互动; 1-直投
     */
    private Integer advertiserType;

    /**
     * 交易平台广告位ID
     */
    private String posId;

    /**
     * 状态 （0：关，1：开）默认为1
     */
    private Integer status;

    /**
     * 开始时间
     */
    private String startDate;

    /**
     * 结束时间
     */
    private String endDate;
}
