/**
 * Project Name:media-manager-biz<br>
 * File Name:ReqActivityPageQuery.java<br>
 * Package Name:cn.com.duiba.tuia.media.manager.model.req<br>
 * Date:2017年1月13日下午4:09:36<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.activity.center.api.dto.algo;

import cn.com.duiba.tuia.activity.center.api.dto.risk.AuditDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.jetbrains.annotations.TestOnly;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 介绍: 皮肤主副标题
 *
 * @author: 阿海
 * @create: 2020-01-09 18:19
 */
@Data
@ToString
@EqualsAndHashCode(callSuper=false)
public class ActivitySkinTitleDTO extends AuditDto {

    private Long id;
    /**
     * 标题类别，主1副2
     */
    private Integer titleType;
    /**
     * 标题内容
     */
    private String titleContent;

    /**
     * 标题内容长度，string的数字，如6.5
     */
    private String titleContentLength;

    /**
     * 昨日标题使用次数，数据回流
     */
    private Long titleCountNum;
    /**
     * 是否关联行业标签，默认0否，1是
     */
    private Integer isOrientIndustrial;
    /**
     * 是否定向活动皮肤，默认0否，1是
     */
    private Integer isOrientSkin;
    /**
     * 是否指定奖品标签，默认0否，1是
     */
    private Integer isOrientAward;
    /**
     * 标题标签id
     */
    private Long titleTagId;
    /**
     * 标题标签名称
     */
    private String titleTagName;

    /**
     * 是否删除（1：删除 0：正常，上线）
     */
    private Integer isDeleted;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 字符串裁剪次数
     */
    private Integer titleFontCutNum;

    /**
     * 副标题是否是当前主标题的黑名单，true：是，false：否
     */
    private Boolean isCurrentBlack;
}
