package cn.com.duiba.tuia.activity.center.api.dto;


import cn.com.duiba.tuia.activity.center.api.constant.OptionUserType;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * ClassName: ActivityOptionDto <br/>
 * Function: 活动奖项Dto. <br/>
 * date: 2017年2月24日 下午2:17:46 <br/>
 *
 * @author wubo
 * @since JDK 1.7
 */
public class ActivityOptionDto extends OptionDto {

    private static final long serialVersionUID = -1115120469267768221L;

    private String            image;                                   // 奖品图片url
    private String            detailImg;                               // 奖品详情图片 url
    private String            description;                             // 奖品说明
    private String            detailDesc;                              // 奖品详情说明
    private Integer           payload;                                 // 排序权重
    private Integer           hidden;                                  // 奖品说明是否展示


    private Integer           guaranteedNum;                           // 保底人数 - 已废弃，待删除
    private Integer           dayLimitNum;                             // 每日发奖限制 - 已废弃，待删除
    private String            noticePeople;                            //报警提醒人

    private Integer userType;

    private List<Integer> joinTimes;

    private Integer rewardAmountType; //定制需要  0- 普通   1- 代码里面动态修改虚拟奖品奖励数量

    //----------------新增预发券参数-------------------//

    /** 优惠券描述，即详情文案. */
    private String couponRemark;

    /** 缩略图的url地址. */
    private String thumbnailPngUrl;

    /** 券的副标题. */
    private String viceTitle;

    /** 优惠券有效期的开始时间. */
    private String startValid;

    /** 优惠券有效期的结束时间. */
    private String endValid;

    /** 该优惠券的价格(分). */
    private long couponPrice;



    public String getImage() {
        return image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getDetailImg() {
        return detailImg;
    }

    public void setDetailImg(String detailImg) {
        this.detailImg = detailImg;
    }


    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDetailDesc() {
        return detailDesc;
    }

    public void setDetailDesc(String detailDesc) {
        this.detailDesc = detailDesc;
    }

    public Integer getPayload() {
        return payload;
    }

    public void setPayload(Integer payload) {
        this.payload = payload;
    }

    public Integer getHidden() {
        return hidden;
    }

    public void setHidden(Integer hidden) {
        this.hidden = hidden;
    }


    public Integer getGuaranteedNum() {
        return guaranteedNum;
    }

    public void setGuaranteedNum(Integer guaranteedNum) {
        this.guaranteedNum = guaranteedNum;
    }

    public Integer getDayLimitNum() {
        return dayLimitNum;
    }

    public void setDayLimitNum(Integer dayLimitNum) {
        this.dayLimitNum = dayLimitNum;
    }

    public Integer getUserType() {
        return userType;
    }

    public void setUserType(Integer userType) {
        this.userType = userType;
    }

    public List<Integer> getJoinTimes() {
        return joinTimes;
    }

    public void setJoinTimes(List<Integer> joinTimes) {
        this.joinTimes = joinTimes;
    }

    public Integer getRewardAmountType() {
        return rewardAmountType;
    }

    public void setRewardAmountType(Integer rewardAmountType) {
        this.rewardAmountType = rewardAmountType;
    }

    public static Map<Integer,List<ActivityOptionDto>> toVOsSplitByUserType(List<ActivityOptionDto> dtos) {
        if (CollectionUtils.isNotEmpty(dtos)) {
            return dtos.stream().filter(e->!Objects.equals(e.getUserType(), OptionUserType.DEFAULT.getCode())).collect(Collectors.groupingBy(ActivityOptionDto::getUserType));
        }
        return Maps.newHashMap();
    }

    public String getNoticePeople() {
        return noticePeople;
    }

    public void setNoticePeople(final String noticePeople) {
        this.noticePeople = noticePeople;
    }

    public String getCouponRemark() {
        return couponRemark;
    }

    public void setCouponRemark(String couponRemark) {
        this.couponRemark = couponRemark;
    }

    public String getThumbnailPngUrl() {
        return thumbnailPngUrl;
    }

    public void setThumbnailPngUrl(String thumbnailPngUrl) {
        this.thumbnailPngUrl = thumbnailPngUrl;
    }

    public String getViceTitle() {
        return viceTitle;
    }

    public void setViceTitle(String viceTitle) {
        this.viceTitle = viceTitle;
    }

    public String getStartValid() {
        return startValid;
    }

    public void setStartValid(String startValid) {
        this.startValid = startValid;
    }

    public String getEndValid() {
        return endValid;
    }

    public void setEndValid(String endValid) {
        this.endValid = endValid;
    }

    public long getCouponPrice() {
        return couponPrice;
    }

    public void setCouponPrice(long couponPrice) {
        this.couponPrice = couponPrice;
    }
}
