package cn.com.duiba.tuia.activity.center.api.constant.adx;

import cn.com.duiba.tuia.activity.center.api.dto.adx.ResourceIdeaDto;
import com.google.common.collect.Lists;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

/**
 * Apus 广告位类型枚举
 *
 * @author peanuthuang
 */
public enum ApusSpecEnum {
   
    /** apus信息流：大图 */
    A_PUS_001("001", "APUS-信息流", 34, "1-2", "大图",
            Lists.newArrayList(600), Lists.newArrayList(400), 1, 150, "jpg/png/jpeg/gif", 30, 30),

    /** apus开屏： */
    A_PUS_002("002", "APUS-开屏", 35, "", "大图",
            Lists.newArrayList(1080), Lists.newArrayList(1920), 1, 150, "jpg/png/jpeg", null, null),

    /** apus插屏： */
    A_PUS_003("003", "APUS-插屏", 36, "1-2", "大图",
            Lists.newArrayList(600), Lists.newArrayList(400), 1, 150, "jpg/png/jpeg/gif", 30, 30),

    /** apus原生： */
    A_PUS_004("004", "APUS-原生-图文摘要", 37, "1-2", "大图+icon",
            Lists.newArrayList(600), Lists.newArrayList(400), 1, 150, "jpg/png/jpeg/gif", 30, 30),

    A_PUS_005("005", "APUS-原生-大图", 38, "", "大图",
            Lists.newArrayList(1080), Lists.newArrayList(1920), 1, 150, "jpg/png/jpeg/gif", null, null)

    ;

    /** 广告类型编码 */
    private String specCode;

    /** dsp侧广告类型名称 */
    private String name;

    /** 规格样式 */
    private Integer styleStandard;

    /** 广告样式 */
    private String template;

    /** 广告样式描述 */
    private String templateDescription;

    /** 素材宽度 */
    private List<Integer> picW;

    /** 素材高度 */
    private List<Integer> picH;

    /** 素材个数 */
    private Integer picNum;

    /** 素材大小 */
    private Integer size;

    /** 素材格式 */
    private String picType;

    /** 标题限制字数 */
    private Integer titleLimit;

    /** 描述字数限制 */
    private Integer contentLimit;

    /**
     * constructor
     * @param specCode
     * @param name
     * @param styleStandard
     * @param template
     * @param templateDescription
     * @param picW
     * @param picH
     * @param picNum
     * @param size
     * @param picType
     * @param titleLimit
     * @param contentLimit
     */
    ApusSpecEnum(String specCode, String name, Integer styleStandard, String template, String templateDescription,
                     List<Integer> picW, List<Integer> picH, Integer picNum, Integer size, String picType, Integer titleLimit, Integer contentLimit) {
        this.specCode = specCode;
        this.name = name;
        this.styleStandard = styleStandard;
        this.template = template;
        this.templateDescription = templateDescription;
        this.picW = picW;
        this.picH = picH;
        this.picNum = picNum;
        this.size = size;
        this.picType = picType;
        this.titleLimit = titleLimit;
        this.contentLimit = contentLimit;
    }

    public String getName() {
        return name;
    }

    public Integer getStyleStandard() {
        return styleStandard;
    }

    public String getTemplate() {
        return template;
    }

    public String getTemplateDescription() {
        return templateDescription;
    }

    public String getSpecCode() {
        return specCode;
    }

    public List<Integer> getPicW() {
        return picW;
    }

    public List<Integer> getPicH() {
        return picH;
    }

    public Integer getSize() {
        return size;
    }

    public String getPicType() {
        return picType;
    }

    public Integer getTitleLimit() {
        return titleLimit;
    }

    public Integer getPicNum() {
        return picNum;
    }

    public Integer getContentLimit() { return contentLimit; }

    /**
     * 根据styleStandard查询对应的枚举
     *
     * @param styleStandard
     * @return
     */
    public static ApusSpecEnum getEnumByStyleStandard(Integer styleStandard) {
        if (Objects.isNull(styleStandard)) {
            return null;
        }

        return Stream.of(ApusSpecEnum.values())
                    .filter(e -> e.getStyleStandard().equals(styleStandard))
                    .findFirst()
                    .orElse(null);
    }


    /**
     * 判断当前创意是否是摘要
     *
     * @param ideaDto
     * @return
     */
    public static boolean isInfoFlow(ResourceIdeaDto ideaDto) {
        if (ideaDto == null || Objects.isNull(ideaDto.getStyleStandard())) {
            return false;
        }

        ApusSpecEnum specEnum = ApusSpecEnum.getEnumByStyleStandard(ideaDto.getStyleStandard());
        return Objects.nonNull(specEnum) &&
                (specEnum == ApusSpecEnum.A_PUS_001
                        || specEnum == ApusSpecEnum.A_PUS_003
                        || specEnum == ApusSpecEnum.A_PUS_004);
    }

    /**
     * 判断当前创意是否是摘要
     *
     * @param ideaDto
     * @return
     */
    public static boolean isSummary(ResourceIdeaDto ideaDto) {
        if (Objects.isNull(ideaDto) || Objects.isNull(ideaDto.getStyleStandard())) {
            return false;
        }

        ApusSpecEnum specEnum = ApusSpecEnum.getEnumByStyleStandard(ideaDto.getStyleStandard());
        return Objects.nonNull(specEnum) && (
                specEnum == ApusSpecEnum.A_PUS_001
                || specEnum == ApusSpecEnum.A_PUS_003
                || specEnum == ApusSpecEnum.A_PUS_004
                );
    }
}
