package cn.com.duiba.tuia.activity.center.api.dto.algo;

import cn.com.duiba.tuia.activity.center.api.constant.algo.AlgoStatusEnum;
import cn.com.duiba.tuia.ssp.center.api.dto.BaseDto;
import lombok.Data;

import java.util.Date;


/**
 *  @author: xuesong
 *  @Date: 2019-12-05 15:43
 *  @Description:   算法模型
 */
@Data
public class AlgoDTO extends BaseDto {

    private static final long serialVersionUID = -7785020844990605418L;
    /**
     *  算法名
     */
    private String algoName;


    /**
     *  算法版本
     */
    private String algoVersion;


    /**
     *  算法类型
     */
    private String algoType;

    /**
     *  操作人
     */
    private String operatorName;


    /**
     *  备注
     */
    private String remark;


    /**
     *  仅投subActivityWay
     */
    private Integer algoOnlySub;


    /**
     *  优投subActivityWay
     */
    private Integer algoPrioritySub;


    /**
     *  算法状态：{@link AlgoStatusEnum}
     */
    private Integer algoStatus;


    /**
     *  发布时间
     */
    private Date publishTime;
}
