/**
 * Copyright (c) 2019, duiba.com.cn All Rights Reserved.
 */
package cn.com.duiba.tuia.activity.center.api.util;

import cn.com.duiba.tuia.activity.center.api.constant.TuiaActivityTypeEnum;

import java.util.Objects;

/**
 * 描述: dsm2的一些公用方法
 *
 * @version v1.0
 * @auther guopengfei@duiba.com.cn
 * @date 2019/3/13 23:37
 */
public class Dsm2Utils {

    /*
        1（活动页面）	    活动ID
        2（自定义活动）	自定义活动ID
        3（直投页）	    直投页ID
        5（主会场）	    主会场ID
        6（原生态活动）	原生态活动ID
    */

    private Dsm2Utils() {
    }

    /**
     * 根据活动类型活动
     *
     * @param activityType
     * @return
     */
    public static Integer getDsm2CForActivity(Integer activityType) {
        if (activityType == null) {
            //默认普通活动吧
            return 1;
        }
        if (TuiaActivityTypeEnum.isCustomize(activityType)) {
            return 2;
        }
        if (TuiaActivityTypeEnum.isShortLink(activityType)) {
            return 6;
        }
        return 1;
    }

    /**
     * 根据流量引导页类型获取
     *
     * @param pageType 1主会场-半弃用 2活动中心-基本弃用 3流量引导页
     * @return
     */
    public static Integer getDsm2CForGuidePage(Integer pageType) {
        if (pageType == null) {
            //默认直投页吧
            return 3;
        }
        if (Objects.equals(pageType, 1)) {
            return 5;
        }

        if (Objects.equals(pageType, 3)) {
            return 3;
        }
        return 3;
    }
}
